/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config.local;

import com.digiwin.app.adapter.ResourceBundleAdapter;
import com.digiwin.app.common.config.reader.resourcebundle.ResourceBundleReader;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.resource.IDWI18nPropertiesReader;
import com.digiwin.app.resource.utils.DWModularI18nUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class DWI18nPropertiesLocalReader
implements ResourceBundleReader,
IDWI18nPropertiesReader {
    private static Log _log = LogFactory.getLog(DWI18nPropertiesLocalReader.class);
    private Integer[] layerIndexArray = new Integer[]{1, 0, -1};
    private String[] layerIdArray = new String[]{"customization", "industry", "application"};
    private static Map<String, Properties> i18nFileCaches = new HashMap<String, Properties>();

    private String getPlatformCachedKey(String baseName) {
        return "platform:" + baseName;
    }

    public String getPlatformString(String baseName, String key, Object ... patternArguments) {
        String cachedKey = this.getPlatformCachedKey(baseName);
        Properties mergedProperties = this.getPlatformI18nProperties(baseName, null);
        return this.getMessageFromProperties(cachedKey, mergedProperties, true, key, patternArguments);
    }

    public String getApplicationString(String baseName, String key, Object ... patternArguments) {
        String message;
        for (int i = 0; i < this.layerIndexArray.length; ++i) {
            Properties mergedProperties;
            int finalI = i;
            String cachedKey = this.layerIdArray[i] + ":" + baseName;
            message = this.getMessageFromProperties(cachedKey, mergedProperties = this.loadI18nProperties(cachedKey, null, locale -> DWModularI18nUtils.getApplicationI18nFileNames(this.layerIndexArray[finalI], baseName, null)), false, key, patternArguments);
            if (message == null) continue;
            return message;
        }
        message = this.getPlatformString(baseName, key, patternArguments);
        return message;
    }

    public String getModuleString(String moduleName, String baseName, String key, Object ... patternArguments) {
        String message = null;
        for (int i = 0; i < this.layerIndexArray.length; ++i) {
            Properties mergedProperties;
            int finalI = i;
            String cachedKey = "module:" + moduleName + ":" + this.layerIdArray[i] + ":" + baseName;
            message = this.getMessageFromProperties(cachedKey, mergedProperties = this.loadI18nProperties(cachedKey, null, locale -> DWModularI18nUtils.getModuleI18nFileNames(moduleName, this.layerIndexArray[finalI], baseName, locale)), i == this.layerIndexArray.length - 1, key, patternArguments);
            if (message == null) continue;
            return message;
        }
        return message;
    }

    public String getString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
        String result = null;
        try {
            ResourceBundle rb = ResourceBundle.getBundle(baseName, locale, cl);
            if (rb != null) {
                result = rb.getString(key);
            }
        }
        catch (MissingResourceException exception) {
            _log.debug((Object)(DWI18nPropertiesLocalReader.class.getName() + " resource bundle " + baseName + ", key " + key + " not found"));
        }
        catch (Exception exception) {
            _log.error((Object)(DWI18nPropertiesLocalReader.class.getName() + " resource bundle " + baseName + ", key " + key + " not found"), (Throwable)exception);
        }
        if (result == null) {
            ResourceBundleAdapter resourceBundleAdapter = null;
            try {
                resourceBundleAdapter = (ResourceBundleAdapter)SpringContextUtils.getBean((String)"resourceBundleAdapter");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resourceBundleAdapter != null) {
                result = resourceBundleAdapter.getMessage(key, patternArguments, locale);
            }
        }
        if (result == null) {
            return null;
        }
        if (patternArguments != null && patternArguments.length > 0) {
            result = String.format(result, patternArguments);
        }
        return result;
    }

    private String getMessageFromProperties(String baseName, Properties properties, boolean keyNotFoundLogDebug, String key, Object ... patternArguments) {
        if (!properties.containsKey(key)) {
            if (keyNotFoundLogDebug) {
                _log.debug((Object)(DWI18nPropertiesLocalReader.class.getName() + " resource bundle " + baseName + ", key " + key + " not found"));
            }
            return null;
        }
        String result = (String)properties.get(key);
        if (patternArguments != null && patternArguments.length > 0) {
            result = String.format(result, patternArguments);
        }
        return result;
    }

    private Properties loadI18nProperties(String baseName, Locale locale, Function<Locale, String[]> i18nFileNamesProvider) {
        String cachedKey = String.format("(%s)%s", locale == null ? LocaleContextHolder.getLocale() : locale, baseName);
        if (i18nFileCaches.containsKey(cachedKey)) {
            return i18nFileCaches.get(cachedKey);
        }
        String[] i18nFileNames = i18nFileNamesProvider.apply(locale);
        Properties mergedProperties = new Properties();
        for (int j = i18nFileNames.length - 1; j >= 0; --j) {
            Properties properties = this.loadProperties(i18nFileNames[j]);
            mergedProperties.putAll((Map<?, ?>)properties);
        }
        i18nFileCaches.put(cachedKey, mergedProperties);
        return mergedProperties;
    }

    private Properties loadProperties(String path) {
        File propertiesFile = new File(path);
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            try (FileInputStream fileStream = new FileInputStream(propertiesFile);){
                properties.load(fileStream);
            }
            catch (IOException e) {
                _log.error((Object)("DWI18nPropertiesLocalReader loadFileContent failed! FileName=" + path), (Throwable)e);
            }
        }
        return properties;
    }

    private Properties getPlatformI18nProperties(String baseName, Locale locale) {
        String cachedKey = "platform:" + baseName;
        return this.loadI18nProperties(cachedKey, locale, processedLocale -> DWModularI18nUtils.getPlatformI18nFileNames(baseName, processedLocale));
    }

    public Properties getApplicationI18nProperties(String baseName, Locale locale) {
        Properties mergedProperties = new Properties();
        Properties layerProperties = this.getPlatformI18nProperties(baseName, locale);
        mergedProperties.putAll((Map<?, ?>)layerProperties);
        for (int i = this.layerIndexArray.length - 1; i >= 0; --i) {
            int finalI = i;
            String cachedKey = this.layerIdArray[i] + ":" + baseName;
            layerProperties = this.loadI18nProperties(cachedKey, locale, processedLocale -> DWModularI18nUtils.getApplicationI18nFileNames(this.layerIndexArray[finalI], baseName, processedLocale));
            mergedProperties.putAll((Map<?, ?>)layerProperties);
        }
        return mergedProperties;
    }

    public Properties getModuleI18nProperties(String groupName, String baseName, Locale locale) {
        Properties mergedProperties = new Properties();
        for (int i = this.layerIndexArray.length - 1; i >= 0; --i) {
            int finalI = i;
            String cachedKey = "module:" + groupName + ":" + this.layerIdArray[i] + ":" + baseName;
            Properties layerProperties = this.loadI18nProperties(cachedKey, locale, processedLocale -> DWModularI18nUtils.getModuleI18nFileNames(groupName, this.layerIndexArray[finalI], baseName, processedLocale));
            mergedProperties.putAll((Map<?, ?>)layerProperties);
        }
        return mergedProperties;
    }
}

