/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceInvocationProcessor;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.service.DWServiceLocationInfo;

public class DWModuleServiceInvocationProcessor
implements DWServiceInvocationProcessor {
    private static ThreadLocal<String> _currentModuleName = new ThreadLocal();

    public void beforeInvoke(DWServiceLocationInfo locationInfo) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        _currentModuleName.set(moduleName == null ? locationInfo.getGroup() : moduleName);
    }

    public void onInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        DWModuleClassLoader.setCurrentModuleName((String)locationInfo.getGroup());
    }

    public void afterInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        DWModuleClassLoader.setCurrentModuleName((String)_currentModuleName.get());
    }

    public void beforeInvoke(DWHeader header, DWMethod method) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        DWModuleClassLoader.setCurrentModuleName((String)(moduleName == null ? header.getModuleName() : moduleName));
        _currentModuleName.set(moduleName == null ? header.getModuleName() : moduleName);
    }

    public void onInvoke(DWHeader header, DWMethod method, Object service) {
        DWModuleClassLoader.setCurrentModuleName((String)header.getModuleName());
    }

    public void afterInvoke(DWHeader header, DWMethod method, Object service) {
        DWModuleClassLoader.setCurrentModuleName((String)_currentModuleName.get());
    }
}

