/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceInvocationProcessor;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.service.DWServiceLocationInfo;
import java.util.Stack;

public class DWModuleServiceInvocationProcessor
implements DWServiceInvocationProcessor {
    private static ThreadLocal<Stack<String>> _currentModuleNames = new ThreadLocal();

    public void beforeInvoke(DWServiceLocationInfo locationInfo) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        Stack<String> currentModuleNames = _currentModuleNames.get();
        if (currentModuleNames == null) {
            currentModuleNames = new Stack();
        }
        currentModuleNames.push(moduleName == null ? locationInfo.getGroup() : moduleName);
        _currentModuleNames.set(currentModuleNames);
    }

    public void onInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        DWModuleClassLoader.setCurrentModuleName((String)locationInfo.getGroup());
    }

    public void afterInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        Stack<String> currentModuleNames = _currentModuleNames.get();
        if (currentModuleNames == null) {
            currentModuleNames = new Stack();
            currentModuleNames.push(locationInfo.getGroup());
        }
        String currentModuleName = currentModuleNames.pop();
        DWModuleClassLoader.setCurrentModuleName((String)currentModuleName);
        if (currentModuleNames.empty()) {
            currentModuleNames.push(currentModuleName);
        }
        _currentModuleNames.set(currentModuleNames);
    }

    public void beforeInvoke(DWHeader header, DWMethod method) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        DWModuleClassLoader.setCurrentModuleName((String)(moduleName == null ? header.getModuleName() : moduleName));
        Stack<String> currentModuleNames = _currentModuleNames.get();
        if (currentModuleNames == null) {
            currentModuleNames = new Stack();
        }
        currentModuleNames.push(moduleName == null ? header.getModuleName() : moduleName);
        _currentModuleNames.set(currentModuleNames);
    }

    public void onInvoke(DWHeader header, DWMethod method, Object service) {
        DWModuleClassLoader.setCurrentModuleName((String)header.getModuleName());
    }

    public void afterInvoke(DWHeader header, DWMethod method, Object service) {
        Stack<String> currentModuleNames = _currentModuleNames.get();
        if (currentModuleNames == null) {
            currentModuleNames = new Stack();
            currentModuleNames.push(header.getModuleName());
        }
        String currentModuleName = currentModuleNames.pop();
        DWModuleClassLoader.setCurrentModuleName((String)currentModuleName);
        if (currentModuleNames.empty()) {
            currentModuleNames.push(currentModuleName);
        }
        _currentModuleNames.set(currentModuleNames);
    }
}

