/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.module.utils.DWProfileScanHelper;
import com.digiwin.app.module.utils.DWServiceScanHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DWModuleInfoProvider {
    private static Map<String, List<Class<?>>> _interfaces;
    private static Map<String, List<DWServiceInfo>> _implementations;

    public static List<String> getPlatformModulePaths() {
        ArrayList<String> platformModulePaths = new ArrayList<String>();
        platformModulePaths.add(DWPathUtils.getPlatformModulePath());
        return platformModulePaths;
    }

    public static List<String> getApplicationModulePaths() {
        ArrayList<String> applicationModulePaths = new ArrayList<String>();
        applicationModulePaths.add(DWPathUtils.getApplicationModulePath());
        applicationModulePaths.add(DWPathUtils.getIndustryModulePath());
        applicationModulePaths.add(DWPathUtils.getCustomizationModulePath());
        return applicationModulePaths;
    }

    public static Map<String, List<Class<?>>> getInterfaceInfos() {
        return _interfaces;
    }

    public static Map<String, List<DWServiceInfo>> getImplementationInfos() {
        return _implementations;
    }

    public static List<Class<?>> getInterfaceInfos(String moduleName) {
        return DWModuleInfoProvider.getInterfaceInfos(moduleName, false);
    }

    public static List<DWServiceInfo> getImplementationInfos(String moduleName) {
        return DWModuleInfoProvider.getImplementationInfos(moduleName, false);
    }

    public static List<Class<?>> getInterfaceInfos(String moduleName, boolean refreshable) {
        if (refreshable) {
            DWModuleClassLoader.removeModuleClassLoader((String)moduleName);
            DWModuleSpringUtils.refresh(moduleName);
            List<String> platformModulePaths = DWModuleInfoProvider.getPlatformModulePaths();
            List<String> applicationModulePaths = DWModuleInfoProvider.getApplicationModulePaths();
            DWProfileScanHelper interfaceScanHelper = new DWProfileScanHelper(platformModulePaths, applicationModulePaths);
            Map interfaces = (Map)interfaceScanHelper.scan(moduleName);
            _interfaces.putAll(interfaces);
        }
        return _interfaces.get(moduleName);
    }

    public static List<DWServiceInfo> getImplementationInfos(String moduleName, boolean refreshable) {
        if (refreshable) {
            List<String> platformModulePaths = DWModuleInfoProvider.getPlatformModulePaths();
            List<String> applicationModulePaths = DWModuleInfoProvider.getApplicationModulePaths();
            DWServiceScanHelper implementationScanHelper = new DWServiceScanHelper(platformModulePaths, applicationModulePaths);
            Map implementations = (Map)implementationScanHelper.scan(moduleName);
            _implementations.putAll(implementations);
        }
        return _implementations.get(moduleName);
    }

    static {
        List<String> platformModulePaths = DWModuleInfoProvider.getPlatformModulePaths();
        List<String> applicationModulePaths = DWModuleInfoProvider.getApplicationModulePaths();
        DWProfileScanHelper interfaceScanHelper = new DWProfileScanHelper(platformModulePaths, applicationModulePaths);
        _interfaces = (Map)interfaceScanHelper.scan();
        DWServiceScanHelper implementationScanHelper = new DWServiceScanHelper(platformModulePaths, applicationModulePaths);
        _implementations = (Map)implementationScanHelper.scan();
        System.out.println(">>>DWModuleInfoProvider 2");
        System.out.println(">>>DWModuleInfoProvider _interfaces" + _interfaces);
        System.out.println(">>>DWModuleInfoProvider _implementations" + _implementations);
    }
}

