/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleFileInfo;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class DWModuleScanHelper<T> {
    private List<String> _platformModulePaths;
    private List<String> _applicationModulePaths;
    private String _extensionName;

    public DWModuleScanHelper(String extensionName) {
        this._extensionName = extensionName;
    }

    public DWModuleScanHelper(List<String> platformModulePaths, List<String> applicationModulePaths, String extensionName) {
        this._platformModulePaths = platformModulePaths;
        this._applicationModulePaths = applicationModulePaths;
        this._extensionName = extensionName;
    }

    public DWModuleScanHelper() {
    }

    public T scan() {
        T scanContext = this.createScanContext();
        this.innerScan(scanContext, this._platformModulePaths, true, null);
        this.innerScan(scanContext, this._applicationModulePaths, false, null);
        return scanContext;
    }

    public void innerScan(T scanContext, List<String> paths, boolean isPlatformModule, String targetModuleName) {
        for (String path : paths) {
            File modulePath = new File(path);
            List<File> modulePathDirs = DWModuleScanHelper.getModuleFiles(modulePath, targetModuleName);
            for (File moduleFile : modulePathDirs) {
                String moduleName = moduleFile.getName();
                ArrayList<DWModuleFileInfo> fileInfoList = new ArrayList<DWModuleFileInfo>();
                this.createModuleFileList(fileInfoList, moduleFile, moduleName, isPlatformModule);
                this.onModuleScan(moduleName, fileInfoList, scanContext);
            }
        }
    }

    protected List<File> getLibFiles(File file) {
        ArrayList<File> result = new ArrayList<File>();
        FileFilter extensionFilter = this._extensionName == null ? null : DWModuleScanHelper.getExtensionFilter(this._extensionName);
        File[] filteredFiles = file.listFiles(extensionFilter);
        if (filteredFiles != null) {
            for (File filtersFile : filteredFiles) {
                result.add(filtersFile);
            }
        }
        return result;
    }

    protected List<DWModuleFileInfo> createModuleFileList(List<DWModuleFileInfo> fileInfoList, File file, String directoryLayer, boolean isPlatformModule) {
        FileFilter extensionFilter;
        FileFilter fileFilter = extensionFilter = this._extensionName == null ? null : DWModuleScanHelper.getExtensionFilter(this._extensionName);
        if (fileInfoList == null) {
            fileInfoList = new ArrayList<DWModuleFileInfo>();
        }
        File[] files = file.listFiles(extensionFilter);
        DWModuleFileInfo fileInfo = new DWModuleFileInfo(files, file);
        String parentDirectoryLayer = StringUtils.substringBeforeLast((String)directoryLayer, (String)"\\");
        fileInfo.setDirectoryLayer(directoryLayer);
        fileInfo.setParentDirectoryLayer(parentDirectoryLayer);
        fileInfo.setPlatformModule(isPlatformModule);
        fileInfoList.add(fileInfo);
        return fileInfoList;
    }

    public T scan(String moduleName) {
        if (moduleName == null || moduleName.isEmpty()) {
            throw new IllegalArgumentException("moduleName is null or empty!");
        }
        T scanContext = this.createScanContext();
        this.innerScan(scanContext, this._platformModulePaths, true, moduleName);
        this.innerScan(scanContext, this._applicationModulePaths, false, moduleName);
        return scanContext;
    }

    protected abstract T createScanContext();

    protected abstract void onModuleScan(String var1, List<DWModuleFileInfo> var2, T var3);

    private static FileFilter getExtensionFilter(final String extensionName) {
        if (extensionName == null || extensionName.isEmpty()) {
            return null;
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return file.isFile() && file.getName().toLowerCase().endsWith("." + extensionName);
            }
        };
        return filter;
    }

    protected static List<File> getModuleFiles(File targetFile, String moduleName) {
        File[] targetModuleFiles;
        ArrayList<File> result = new ArrayList<File>();
        for (File targetModuleFile : targetModuleFiles = targetFile.listFiles()) {
            if (!targetModuleFile.isDirectory()) continue;
            if (moduleName != null) {
                if (!targetModuleFile.getName().equals(moduleName)) continue;
                result.add(targetModuleFile);
                break;
            }
            result.add(targetModuleFile);
        }
        return result;
    }
}

