/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.service.DWService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;

public final class DWProxyUtils {
    public static Object createProxy(DWService service, InvocationHandler handler) {
        return DWProxyUtils.createProxy(service, null, handler);
    }

    public static Object createProxy(DWService service, List<Class<?>> extraSupportInterfaces, InvocationHandler handler) {
        Object targetProxy = null;
        ClassLoader classLoader = service.getClass().getClassLoader();
        Class<?>[] interfaces = DWProxyUtils.getProxyInterfaces(service);
        if (extraSupportInterfaces != null && extraSupportInterfaces.size() > 0) {
            int extraSize = extraSupportInterfaces.size();
            int extraInterfaceIndex = interfaces.length;
            Class<?>[] allInterfaces = Arrays.copyOf(interfaces, interfaces.length + extraSize);
            for (Class<?> interfaceClass : extraSupportInterfaces) {
                allInterfaces[extraInterfaceIndex++] = interfaceClass;
            }
            interfaces = allInterfaces;
        }
        targetProxy = Proxy.newProxyInstance(classLoader, interfaces, handler);
        return targetProxy;
    }

    public static Object createProxy(Class<?> remoteInterface, InvocationHandler handler) {
        Object targetProxy = null;
        ClassLoader classLoader = remoteInterface.getClassLoader();
        Class[] interfaces = new Class[]{remoteInterface, DWService.class};
        targetProxy = Proxy.newProxyInstance(classLoader, interfaces, handler);
        return targetProxy;
    }

    public static Class<?> getDWProfileDerivedInterface(Class<?> clazz) {
        Class<?>[] interfaces;
        Class<?> interfaceClass = null;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (!DWService.class.isAssignableFrom(i)) continue;
            interfaceClass = i;
            break;
        }
        return interfaceClass;
    }

    private static Class<?>[] getProxyInterfaces(DWService service) {
        Class<?>[] proxyInterfaces;
        Class<?>[] ownerInterfaces = service.getClass().getInterfaces();
        boolean foundDWProfileInterface = false;
        for (Class<?> i : ownerInterfaces) {
            if (i != DWService.class) continue;
            foundDWProfileInterface = true;
            break;
        }
        if (foundDWProfileInterface) {
            proxyInterfaces = ownerInterfaces;
        } else {
            proxyInterfaces = Arrays.copyOf(ownerInterfaces, ownerInterfaces.length + 1);
            proxyInterfaces[ownerInterfaces.length] = DWService.class;
        }
        return proxyInterfaces;
    }
}

