/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModuleFileInfo;
import com.digiwin.app.module.utils.DWModuleScanHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWModuleClassScanHelper<T>
extends DWModuleScanHelper<T> {
    protected static Log _log = LogFactory.getLog(DWModuleClassScanHelper.class);

    public DWModuleClassScanHelper() {
        super("class");
    }

    public DWModuleClassScanHelper(List<String> platformModulePaths, List<String> applicationModulePaths) {
        super(platformModulePaths, applicationModulePaths, "class");
    }

    @Override
    public void innerScan(T scanContext, List<String> paths, boolean isPlatformModule, String targetModuleName) {
        for (String path : paths) {
            File modulePath = new File(path);
            List<File> modulePathDirs = DWModuleClassScanHelper.getModuleFiles(modulePath, targetModuleName);
            for (File moduleFile : modulePathDirs) {
                String moduleName = moduleFile.getName();
                ArrayList<DWModuleFileInfo> fileInfoList = new ArrayList<DWModuleFileInfo>();
                this.createModuleFileList(fileInfoList, moduleFile, moduleName, isPlatformModule);
                this.onModuleScan(moduleName, fileInfoList, scanContext);
            }
        }
    }

    @Override
    protected List<DWModuleFileInfo> createModuleFileList(List<DWModuleFileInfo> fileInfoList, File file, String directoryLayer, boolean isPlatformModule) {
        if (fileInfoList == null) {
            fileInfoList = new ArrayList<DWModuleFileInfo>();
        }
        List<File> foundFiles = this.findAllFiles(file, this._extensionName);
        DWModuleFileInfo fileInfo = new DWModuleFileInfo(foundFiles.toArray(new File[foundFiles.size()]), file);
        String parentDirectoryLayer = StringUtils.substringBeforeLast((String)directoryLayer, (String)"\\");
        fileInfo.setDirectoryLayer(directoryLayer);
        fileInfo.setParentDirectoryLayer(parentDirectoryLayer);
        fileInfo.setPlatformModule(isPlatformModule);
        fileInfoList.add(fileInfo);
        return fileInfoList;
    }

    protected List<File> findAllFiles(File rootFile, String extensionName) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : rootFile.listFiles()) {
            if (file.isDirectory()) {
                result.addAll(this.findAllFiles(file, extensionName));
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(extensionName)) continue;
            result.add(file);
        }
        return result;
    }

    @Override
    protected void onModuleScan(String moduleName, List<DWModuleFileInfo> fileInfoList, T scanContext) {
        for (DWModuleFileInfo fileInfo : fileInfoList) {
            File directoryFile = fileInfo.getDirectoryFile();
            File[] files = fileInfo.getFiles();
            DWModuleClassLoader classLoader = this.getClassLoader(moduleName, fileInfo);
            for (File file : files) {
                String fileName = file.getName();
                if (fileName.contains("$")) continue;
                String className = null;
                try {
                    className = file.getCanonicalPath().replace(directoryFile.getCanonicalPath(), "").substring(1);
                    className = className.replace("\\", ".").replace(".class", "");
                    Class clazz = classLoader.loadClass(className);
                    this.onClassScan(moduleName, classLoader, clazz, scanContext);
                }
                catch (Throwable e) {
                    this.onClassScanFailed(moduleName, className, e);
                }
            }
        }
    }

    protected abstract void onClassScan(String var1, DWModuleClassLoader var2, Class<?> var3, T var4);

    protected void onClassScanFailed(String moduleName, String className, Throwable e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(moduleName).append("]");
        message.append(" class=").append(className).append(" scan failed!");
        _log.error((Object)message, e);
    }
}

