/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleJarScanInfo {
    private List<String> _primaryModuleJarList = new ArrayList<String>();
    private Map<String, List<String>> _scanInfo = new HashMap<String, List<String>>();

    void cacheClassInfo(String moduleName, String jarName, String className) {
        String key = this.getKey(moduleName, jarName);
        List<String> classInfos = this._scanInfo.get(key);
        if (classInfos == null) {
            classInfos = new ArrayList<String>();
            this._scanInfo.put(key, classInfos);
        }
        classInfos.add(className);
    }

    String getKey(String moduleName, String jarName) {
        return moduleName + "_" + jarName;
    }

    void addToPrimaryList(String moduleName, String jarName) {
        String key = this.getKey(moduleName, jarName);
        if (!this._primaryModuleJarList.contains(key)) {
            this._primaryModuleJarList.add(key);
        }
    }

    boolean isPrimaryJar(String moduleName, String jarName) {
        String key = this.getKey(moduleName, jarName);
        return this._primaryModuleJarList.contains(key);
    }

    List<String> getClassNameList(String moduleName, String jarName) {
        String key = this.getKey(moduleName, jarName);
        return this._scanInfo.get(key);
    }

    void clear() {
        this._primaryModuleJarList.clear();
        this._scanInfo.clear();
    }
}

