/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.config;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.digiwin.app.dao.mybatis.DWMybatisDao;
import com.digiwin.app.dao.mybatis.DWMybatisProperties;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={MybatisPlusProperties.class})
@AutoConfigureBefore(value={MybatisPlusAutoConfiguration.class})
@ConditionalOnProperty(prefix="dap.mybatis", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class DWMybatisPlusAutoConfiguration {
    private static final Logger _logger = LoggerFactory.getLogger(DWMybatisPlusAutoConfiguration.class);

    @Bean(name={"dw-mybatis-properties"})
    @ConditionalOnMissingBean
    public DWMybatisProperties dwMybatisProperties(ApplicationContext context) {
        DWMybatisProperties dwMyBatisProperties = null;
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.mybatis");
        BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(DWMybatisProperties.class), (BindHandler)handler);
        dwMyBatisProperties = bindResult.isBound() ? (DWMybatisProperties)bindResult.get() : new DWMybatisProperties();
        _logger.info(dwMyBatisProperties.toString());
        return dwMyBatisProperties;
    }

    @Deprecated
    @Bean(name={"dw-mybatis-dao"})
    public DWMybatisDao dwMybatis() {
        DWMybatisDao dwMybatisDao = new DWMybatisDao();
        return dwMybatisDao;
    }

    @Bean
    @ConditionalOnMissingBean
    public MapperScannerConfigurer dwMapperScannerConfigurer(@Qualifier(value="dw-mybatis-properties") DWMybatisProperties dwMybatisProperties) {
        MapperScannerConfigurer dwMapperScanner = new MapperScannerConfigurer();
        if (!StringUtils.isEmpty((String)dwMybatisProperties.getBasePackage())) {
            dwMapperScanner.setBasePackage(dwMybatisProperties.getBasePackage());
        }
        return dwMapperScanner;
    }
}

