/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.service.DWServiceContext;
import com.google.common.collect.Maps;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class DWMybatistLogOperationSQLInnerInterceptor
implements Interceptor {
    private static Log LOGGER = LogFactory.getLog(DWMybatistLogOperationSQLInnerInterceptor.class);
    private static final String LOGTAG = "[" + DWMybatistLogOperationSQLInnerInterceptor.class.getSimpleName() + "]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        long costTime = 0L;
        StopWatch stopWatch = null;
        BoundSql boundSql = null;
        Map<Object, Object> mapperStatamentInfo = Maps.newHashMap();
        if (target instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)target;
            boundSql = statementHandler.getBoundSql();
            PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)statementHandler);
            MappedStatement ms = mpSh.mappedStatement();
            mapperStatamentInfo = this.getMappedStatementInfo(ms, boundSql);
        }
        Object returnValue = null;
        try {
            stopWatch = StopWatch.createStarted();
            returnValue = invocation.proceed();
        }
        finally {
            if (null != stopWatch && !stopWatch.isStopped()) {
                stopWatch.stop();
                costTime = stopWatch.getTime();
            }
            if (null != boundSql && this.isLogOperation(boundSql)) {
                this.putSqlInfoToContext(costTime, boundSql.getSql(), mapperStatamentInfo);
            }
        }
        return returnValue;
    }

    private void putSqlInfoToContext(long costTime, String sql, Map<String, Object> mapperStatamentInfo) {
        boolean configOfServiceLogForOperate = false;
        Map operateLogMap = DWServiceContext.getContext().getOperateLog();
        if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogRecord") && ((Boolean)operateLogMap.get("isLogRecord")).booleanValue()) {
            configOfServiceLogForOperate = true;
        }
        if (configOfServiceLogForOperate) {
            boolean combinedConfigValueOfSqlLogForOperate = true;
            boolean collectSqlLogForOperate = false;
            boolean daoOptionValueOfOperateLogEnabled = true;
            if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogSqlRecord")) {
                combinedConfigValueOfSqlLogForOperate = (Boolean)operateLogMap.get("isLogSqlRecord");
            }
            if (combinedConfigValueOfSqlLogForOperate) {
                IDWSQLOptions option = (IDWSQLOptions)mapperStatamentInfo.get("dw-mybatis-data-option");
                collectSqlLogForOperate = option != null ? (daoOptionValueOfOperateLogEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)option.get(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED)), (boolean)true)) : true;
            }
            if (collectSqlLogForOperate) {
                List parameterMappingList = (List)mapperStatamentInfo.get("sqlParameters");
                HashMap<String, Object> currentSqlMap = new HashMap<String, Object>();
                currentSqlMap.put("statement", sql);
                currentSqlMap.put("parameters", parameterMappingList);
                currentSqlMap.put("costTime", costTime);
                HashMap<Integer, HashMap<Integer, HashMap<String, Object>>> logRecordSqlMap = (HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>)operateLogMap.get("sqlMap");
                if (MapUtils.isNotEmpty((Map)logRecordSqlMap)) {
                    logRecordSqlMap.put(logRecordSqlMap.size() + 1, currentSqlMap);
                } else {
                    logRecordSqlMap = new HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>();
                    logRecordSqlMap.put(1, currentSqlMap);
                    operateLogMap.put("sqlMap", logRecordSqlMap);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("collectSqlLogForOperate=%b (configOfServiceLogForOperate=%b , combinedConfigValueOfSqlLogForOperate=%b , daoOptionValueOfOperateLogEnabled=%s !)", collectSqlLogForOperate, configOfServiceLogForOperate, combinedConfigValueOfSqlLogForOperate, daoOptionValueOfOperateLogEnabled));
            }
        }
    }

    private boolean isLogOperation(BoundSql boundSql) {
        DWDataSetOperationOption dataOptions = new DWDataSetOperationOption();
        Object parameterObject = boundSql.getParameterObject();
        if (parameterObject != null && parameterObject instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
            for (Map.Entry entry : paramMap.entrySet()) {
                Object paramValue = entry.getValue();
                if (!(paramValue instanceof IDWSQLOptions)) continue;
                dataOptions = (IDWSQLOptions)paramValue;
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)String.format("%s dataOptions:%s", LOGTAG, dataOptions.toString()));
                break;
            }
        }
        boolean isLogOperaton = BooleanUtils.toBoolean((Boolean)((Boolean)dataOptions.get(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED, (Object)true)));
        return isLogOperaton;
    }

    private Map<String, Object> getMappedStatementInfo(MappedStatement mappedStatement, BoundSql boundSql) {
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        String sqlId = mappedStatement.getId();
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        Configuration configuration = mappedStatement.getConfiguration();
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        ArrayList paramsForLogOperation = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)parameterMappings)) {
            for (int indexOfParamMapping = 0; indexOfParamMapping < parameterMappings.size(); ++indexOfParamMapping) {
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(indexOfParamMapping);
                if (parameterMapping.getMode() != ParameterMode.OUT) {
                    Object value;
                    String propertyName = parameterMapping.getProperty();
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        value = boundSql.getAdditionalParameter(propertyName);
                    } else if (parameterObject == null) {
                        value = null;
                    } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                        value = parameterObject;
                    } else {
                        MetaObject metaObject = configuration.newMetaObject(parameterObject);
                        value = metaObject.getValue(propertyName);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)String.format("%s parameter %d: %s(%s)", LOGTAG, indexOfParamMapping, value, value.getClass().getName()));
                    }
                    paramsForLogOperation.add(indexOfParamMapping, value);
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)String.format("%s parameter %d: mode %s", LOGTAG, indexOfParamMapping, parameterMapping.getMode()));
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("%s parameterMappings is null or empty", LOGTAG));
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("sqlParameters", paramsForLogOperation);
        returnData.put("sqlCommandType", sqlCommandType);
        returnData.put("sqlId", sqlId);
        return returnData;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }
}

