/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn.client;

import com.digiwin.app.queue.DWQueueApplicationContextProvider;
import com.digiwin.app.queue.DWQueueProducer;
import com.digiwin.app.queue.DWQueueSaasProducer;
import com.digiwin.app.queue.DWQueueTenantProducer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationContext;

public abstract class DWPersistconnClient {
    protected String _topic;
    protected String _message;
    protected Integer _timeout;
    protected TimeUnit _timeoutUnit;
    protected DWQueueProducer.CompleteCallback _completeCallback;
    protected DWQueueProducer.TimeoutCallback _timeoutCallback;

    public abstract String invoke() throws Exception;

    protected DWQueueProducer getDWQueueProducer() {
        ApplicationContext context = DWQueueApplicationContextProvider.getApplicationContext();
        DWQueueProducer producer = null;
        switch (DWQueueApplicationContextProvider.getRole()) {
            case "Saas": {
                producer = (DWQueueProducer)context.getBean(DWQueueSaasProducer.class);
                break;
            }
            case "Tenant": {
                producer = (DWQueueProducer)context.getBean(DWQueueTenantProducer.class);
            }
        }
        return producer;
    }

    protected class RpcTimeoutCallback
    implements DWQueueProducer.TimeoutCallback {
        private BlockingQueue<String> response;
        private DWQueueProducer.TimeoutCallback customTimeoutCallback;

        public RpcTimeoutCallback(BlockingQueue<String> response) {
            this.response = response;
            this.customTimeoutCallback = null;
        }

        public RpcTimeoutCallback(BlockingQueue<String> response, DWQueueProducer.TimeoutCallback customTimeoutCallback) {
            this.response = response;
            this.customTimeoutCallback = customTimeoutCallback;
        }

        public void onCallback(String result) {
            this.response.offer(result);
            if (this.customTimeoutCallback != null) {
                this.customTimeoutCallback.onCallback(result);
            }
        }
    }

    protected class RpcCompleteCallback
    implements DWQueueProducer.CompleteCallback {
        private BlockingQueue<String> response;
        private DWQueueProducer.CompleteCallback customCompleteCallback;

        public RpcCompleteCallback(BlockingQueue<String> response) {
            this.response = response;
            this.customCompleteCallback = null;
        }

        public RpcCompleteCallback(BlockingQueue<String> response, DWQueueProducer.CompleteCallback customCompleteCallback) {
            this.response = response;
            this.customCompleteCallback = customCompleteCallback;
        }

        public void onCallback(String result) {
            this.response.offer(result);
            if (this.customCompleteCallback != null) {
                this.customCompleteCallback.onCallback(result);
            }
        }
    }
}

