/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.processor.enums.KeyStoreEnum;
import com.digiwin.queue.saas.SaasClient;
import com.digiwin.queue.tenant.TenantClient;
import org.apache.commons.lang3.StringUtils;

public class DWQueueClientProvider {
    private static SaasClient saasClient = null;
    private static TenantClient tenantClient = null;
    private static int retryTimes = -1;
    private static long retryIntervalSec = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaasClient getSaasClient() throws Exception {
        if (saasClient != null) return saasClient;
        Class<SaasClient> clazz = SaasClient.class;
        synchronized (SaasClient.class) {
            String httpPort;
            if (saasClient != null) return saasClient;
            String isHttps = DWApplicationConfigUtils.getProperty((String)"queueSaasRabbitmqIsHttps", (String)"false");
            if (StringUtils.isBlank((CharSequence)isHttps)) {
                isHttps = "false";
            }
            String host = DWApplicationConfigUtils.getProperty((String)"queueSaasRabbitmqHost", (String)"");
            String amqpPort = DWApplicationConfigUtils.getProperty((String)"queueSaasRabbitmqAmqpPort", (String)"5672");
            if (StringUtils.isBlank((CharSequence)amqpPort)) {
                amqpPort = "5672";
            }
            if (StringUtils.isBlank((CharSequence)(httpPort = DWApplicationConfigUtils.getProperty((String)"queueSaasRabbitmqHttpPort", (String)"15672")))) {
                httpPort = "15672";
            }
            String username = DWApplicationConfigUtils.getProperty((String)"queueSaasRabbitmqUsername", (String)"");
            String password = DWApplicationConfigUtils.getProperty((String)"queueSaasRabbitmqPassword", (String)"");
            if (StringUtils.isBlank((CharSequence)host) || StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
                throw new Exception("\u9577\u9023\u63a5Saas\u8a2d\u5b9a\u7570\u5e38(host, username or password)");
            }
            if (StringUtils.isBlank((CharSequence)isHttps)) {
                saasClient = retryTimes <= 0 || retryIntervalSec <= 0L ? SaasClient.init((String)host, (String)username, (String)password) : SaasClient.init((String)host, (String)username, (String)password, (Integer)retryTimes, (Long)retryIntervalSec);
            } else {
                SaasClient.Protocol protocol = SaasClient.Protocol.HTTP;
                if (Boolean.valueOf(isHttps).booleanValue()) {
                    protocol = SaasClient.Protocol.HTTPS;
                }
                saasClient = retryTimes <= 0 || retryIntervalSec <= 0L ? SaasClient.init((SaasClient.Protocol)protocol, (String)host, (Integer)Integer.valueOf(amqpPort), (Integer)Integer.valueOf(httpPort), (String)username, (String)password) : SaasClient.init((SaasClient.Protocol)protocol, (String)host, (Integer)Integer.valueOf(amqpPort), (Integer)Integer.valueOf(httpPort), (String)username, (String)password, (int)retryTimes, (long)retryIntervalSec);
            }
            boolean queueSaasTlsOn = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"queueSaasTlsOn", (String)"false"));
            if (!queueSaasTlsOn) return saasClient;
            if (host.toLowerCase().endsWith(".cn")) {
                saasClient.openSSL(KeyStoreEnum.ALIYUN);
            }
            if (!host.toLowerCase().endsWith(".com")) return saasClient;
            saasClient.openSSL(KeyStoreEnum.AZURE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return saasClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TenantClient getTenantClient() throws Exception {
        if (tenantClient != null) return tenantClient;
        String host = DWApplicationConfigUtils.getProperty((String)"queueTenantProcessorHost", (String)"");
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new Exception("\u9577\u9023\u63a5Tenant\u8a2d\u5b9a\u7570\u5e38(host)");
        }
        Class<TenantClient> clazz = TenantClient.class;
        synchronized (TenantClient.class) {
            if (tenantClient != null) return tenantClient;
            tenantClient = retryTimes <= 0 || retryIntervalSec <= 0L ? TenantClient.init((String)host) : TenantClient.init((String)host, (Integer)retryTimes, (Long)retryIntervalSec);
            boolean queueTenantTlsOn = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"queueTenantTlsOn", (String)"false"));
            if (!queueTenantTlsOn) return tenantClient;
            if (host.toLowerCase().endsWith(".cn")) {
                tenantClient.openSSL(KeyStoreEnum.ALIYUN);
            }
            if (!host.toLowerCase().endsWith(".com")) return tenantClient;
            tenantClient.openSSL(KeyStoreEnum.AZURE);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tenantClient;
        }
    }

    public static void setRetryTimes(int retryTimes) {
        DWQueueClientProvider.retryTimes = retryTimes;
    }

    public static void setRetryIntervalSec(int retryIntervalSec) {
        DWQueueClientProvider.retryIntervalSec = retryIntervalSec;
    }
}

