/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redis.service;

import com.digiwin.app.redis.service.AbstractService;
import com.digiwin.app.redis.service.DWPipielineService;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.serializer.RedisSerializer;

@Deprecated
public class DefaultPipielinedService
extends AbstractService
implements DWPipielineService {
    private RedisConnection connection;
    private RedisSerializer keySerializer = null;
    private RedisSerializer valueSerializer = null;
    private RedisSerializer hashKeySerializer = null;
    private RedisSerializer hashValueSerializer = null;

    public DefaultPipielinedService(RedisTemplate<String, Object> redisTemplate, RedisConnection connection) {
        this.keySerializer = redisTemplate.getKeySerializer();
        this.valueSerializer = redisTemplate.getValueSerializer();
        this.hashKeySerializer = redisTemplate.getHashKeySerializer();
        this.hashValueSerializer = redisTemplate.getHashValueSerializer();
        this.connection = connection;
    }

    @Override
    public void expire(String key, long time) {
        block6: {
            try {
                if (time <= 0L) break block6;
                byte[] rawKey = this.rawKey(key);
                Long rawTimeout = TimeoutUtils.toMillis((long)time, (TimeUnit)TimeUnit.SECONDS);
                try {
                    this.connection.pExpire(rawKey, rawTimeout.longValue());
                }
                catch (Exception e1) {
                    try {
                        this.connection.expire(rawKey, TimeoutUtils.toSeconds((long)time, (TimeUnit)TimeUnit.SECONDS));
                    }
                    catch (Exception e2) {
                        super.logException(e1);
                        super.logException(e2);
                    }
                }
            }
            catch (Exception e) {
                super.logException(e);
            }
        }
    }

    @Override
    public void getExpire(String key) {
        try {
            byte[] rawKey = this.rawKey(key);
            try {
                this.connection.pTtl(rawKey, TimeUnit.SECONDS);
            }
            catch (Exception e1) {
                try {
                    this.connection.ttl(rawKey, TimeUnit.SECONDS);
                }
                catch (Exception e2) {
                    super.logException(e1);
                    super.logException(e2);
                }
            }
        }
        catch (Exception e) {
            super.logException(e);
        }
    }

    @Override
    public void hasKey(String key) {
        try {
            byte[] rawKey = this.rawKey(key);
            this.connection.exists(rawKey);
        }
        catch (Exception e) {
            super.logException(e);
        }
    }

    @Override
    public void remove(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                byte[] rawKey = this.rawKey(key[0]);
                this.connection.del((byte[][])new byte[][]{rawKey});
            } else {
                HashSet<String> set = new HashSet<String>(Arrays.asList(key));
                byte[][] rawKeys = this.rawKeys(set);
                this.connection.del(rawKeys);
            }
        }
    }

    @Override
    public void get(String key) {
        byte[] rawKey = this.rawKey(key);
        this.connection.get(rawKey);
    }

    @Override
    public void set(String key, Object value) {
        try {
            byte[] rawKey = this.rawKey(key);
            byte[] rawValue = this.rawValue(value);
            this.connection.set(rawKey, rawValue);
        }
        catch (Exception e) {
            super.logException(e);
        }
    }

    @Override
    public void set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                byte[] rawKey = this.rawKey(key);
                byte[] rawValue = this.rawValue(value);
                this.connection.setEx(rawKey, TimeoutUtils.toSeconds((long)time, (TimeUnit)TimeUnit.SECONDS), rawValue);
            } else {
                this.set(key, value);
            }
        }
        catch (Exception e) {
            super.logException(e);
        }
    }

    @Override
    public void getHashValue(String key, String hashKey) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        this.connection.hGet(rawKey, rawHashKey);
    }

    @Override
    public void getHash(String key) {
        byte[] rawKey = this.rawKey(key);
        this.connection.hGetAll(rawKey);
    }

    @Override
    public void setHash(String key, Map<String, Object> map) {
        try {
            if (map.isEmpty()) {
                return;
            }
            byte[] rawKey = this.rawKey(key);
            LinkedHashMap<byte[], byte[]> hashes = new LinkedHashMap<byte[], byte[]>(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                hashes.put(this.rawHashKey(entry.getKey()), this.rawHashValue(entry.getValue()));
            }
            this.connection.hMSet(rawKey, hashes);
        }
        catch (Exception e) {
            super.logException(e);
        }
    }

    @Override
    public void setHash(String key, Map<String, Object> map, long time) {
        try {
            this.setHash(key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
        }
        catch (Exception e) {
            super.logException(e);
        }
    }

    @Override
    public void setHashValue(String key, String hashKey, Object value) {
        try {
            byte[] rawKey = this.rawKey(key);
            byte[] rawHashKey = this.rawHashKey(hashKey);
            byte[] rawHashValue = this.rawHashValue(value);
            this.connection.hSet(rawKey, rawHashKey, rawHashValue);
        }
        catch (Exception e) {
            super.logException(e);
        }
    }

    @Override
    public void setHashValue(String key, String hashKey, Object value, long time) {
        try {
            this.setHashValue(key, hashKey, value);
            if (time > 0L) {
                this.expire(key, time);
            }
        }
        catch (Exception e) {
            super.logException(e);
        }
    }

    @Override
    public void removeHashValue(String key, String ... hashKey) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawHashKeys = this.rawHashKeys(hashKey);
        this.connection.hDel(rawKey, rawHashKeys);
    }

    @Override
    public void hasHashKey(String key, String hashKey) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        this.connection.hExists(rawKey, rawHashKey);
    }

    @Override
    public void getHashSize(String key) {
        try {
            byte[] rawKey = this.rawKey(key);
            this.connection.hLen(rawKey);
        }
        catch (Exception e) {
            super.logException(e);
        }
    }

    @Override
    public void incrBy(String key, long num) {
        byte[] rawKey = this.rawKey(key);
        this.connection.incrBy(rawKey, num);
    }

    @Override
    public RedisConnection getOperator() {
        return this.connection;
    }

    private byte[] rawKey(String key) {
        if (this.keySerializer == null) {
            return key.getBytes(StandardCharsets.UTF_8);
        }
        return this.keySerializer.serialize((Object)key);
    }

    private byte[][] rawKeys(Collection<String> keys) {
        byte[][] rawKeys = new byte[keys.size()][];
        int i = 0;
        for (String key : keys) {
            rawKeys[i++] = this.rawKey(key);
        }
        return rawKeys;
    }

    private byte[] rawValue(Object value) {
        if (this.valueSerializer == null && value instanceof byte[]) {
            return (byte[])value;
        }
        return this.valueSerializer.serialize(value);
    }

    private byte[] rawHashKey(String key) {
        if (this.hashKeySerializer == null) {
            return key.getBytes(StandardCharsets.UTF_8);
        }
        return this.hashKeySerializer.serialize((Object)key);
    }

    private byte[][] rawHashKeys(String ... hashKeys) {
        byte[][] rawHashKeys = new byte[hashKeys.length][];
        int i = 0;
        for (String hashKey : hashKeys) {
            rawHashKeys[i++] = this.rawHashKey(hashKey);
        }
        return rawHashKeys;
    }

    <HV> byte[] rawHashValue(HV value) {
        if (this.hashValueSerializer == null & value instanceof byte[]) {
            return (byte[])value;
        }
        return this.hashValueSerializer.serialize(value);
    }
}

