/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redis.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.redis.PipelineTask;
import com.digiwin.app.redis.service.AbstractService;
import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.app.redis.service.DefaultPipielineService;
import com.digiwin.app.redis.service.IDWRedisPrefix;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.ValueOperations;

public class DefaultRedisService
extends AbstractService
implements DWRedisService {
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public Boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            super.logException(e);
            return false;
        }
    }

    @Override
    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    @Override
    public Boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            super.logException(e);
            return false;
        }
    }

    @Override
    public void remove(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                HashSet<String> set = new HashSet<String>(Arrays.asList(key));
                this.redisTemplate.delete(set);
            }
        }
    }

    @Override
    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public Boolean set(String key, Object value) {
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            super.logException(e);
            return false;
        }
    }

    @Override
    public Boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            super.logException(e);
            return false;
        }
    }

    @Override
    public Object getHashValue(String key, String hashKey) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    @Override
    public Map<String, Object> getHash(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    @Override
    public Boolean setHash(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            super.logException(e);
            return false;
        }
    }

    @Override
    public Boolean setHash(final String key, final Map<String, Object> map, final long time) {
        try {
            this.redisTemplate.execute((SessionCallback)new SessionCallback<Object>(){

                public Object execute(RedisOperations operations) throws DataAccessException {
                    operations.multi();
                    operations.opsForHash().putAll((Object)key, map);
                    if (time > 0L) {
                        operations.expire((Object)key, time, TimeUnit.SECONDS);
                    }
                    return operations.exec();
                }
            });
            return true;
        }
        catch (Exception e) {
            super.logException(e);
            return false;
        }
    }

    @Override
    public Boolean setHashValue(String key, String hashKey, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
            return true;
        }
        catch (Exception e) {
            super.logException(e);
            return false;
        }
    }

    @Override
    public Boolean setHashValue(final String key, final String hashKey, final Object value, final long time) {
        try {
            this.redisTemplate.execute((SessionCallback)new SessionCallback<Object>(){

                public Object execute(RedisOperations operations) throws DataAccessException {
                    operations.multi();
                    operations.opsForHash().put((Object)key, (Object)hashKey, value);
                    if (time > 0L) {
                        operations.expire((Object)key, time, TimeUnit.SECONDS);
                    }
                    return operations.exec();
                }
            });
            return true;
        }
        catch (Exception e) {
            super.logException(e);
            return false;
        }
    }

    @Override
    public void removeHashValue(String key, String ... hashKey) {
        Object[] objectHashKey = Arrays.copyOf(hashKey, hashKey.length, Object[].class);
        this.redisTemplate.opsForHash().delete((Object)key, objectHashKey);
    }

    @Override
    public Boolean hasHashKey(String key, String hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    @Override
    public Long getHashSize(String key) {
        try {
            return this.redisTemplate.opsForHash().size((Object)key);
        }
        catch (Exception e) {
            super.logException(e);
            return 0L;
        }
    }

    @Override
    public Set<String> keys(String pattern) {
        HashSet<String> result = new HashSet<String>();
        Set<Object> scanResults = this.scan(pattern);
        for (Object scanResult : scanResults) {
            result.add(String.valueOf(scanResult));
        }
        return result;
    }

    private Set<Object> scan(String pattern) {
        Set result = (Set)this.redisTemplate.execute(connection -> {
            HashSet<String> binaryKeys = new HashSet<String>();
            ScanOptions scanOptions = new ScanOptions.ScanOptionsBuilder().match(pattern + "*").count(Integer.MAX_VALUE).build();
            Cursor cursor = connection.scan(scanOptions);
            while (cursor.hasNext()) {
                binaryKeys.add(new String((byte[])cursor.next()));
            }
            return binaryKeys;
        });
        return result;
    }

    @Override
    public Long incrBy(String key, long num) {
        ValueOperations operations = this.redisTemplate.opsForValue();
        Long result = operations.increment((Object)key, num);
        return result;
    }

    @Override
    public String getPrefixKey(String key) throws DWBusinessException {
        return this.getPrefixKey(key, "redisson-lock-prefix-app");
    }

    @Override
    public String getPrefixKey(String key, String prefixType) throws DWBusinessException {
        IDWRedisPrefix redisPrefix = (IDWRedisPrefix)SpringContextUtils.getBean((String)prefixType);
        return redisPrefix.getKeyName(key);
    }

    @Override
    public List<Object> executePipelined(PipelineTask task) {
        List result = this.redisTemplate.executePipelined(connection -> {
            connection.openPipeline();
            DefaultPipielineService pipielineService = new DefaultPipielineService(this.redisTemplate, connection);
            task.execute(pipielineService);
            return null;
        });
        return result;
    }

    @Override
    public void setOperator(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public RedisTemplate<String, Object> getOperator() {
        return this.redisTemplate;
    }
}

