/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.event.DefaultEventBus;
import io.lettuce.core.event.DefaultEventPublisherOptions;
import io.lettuce.core.event.EventBus;
import io.lettuce.core.event.EventPublisherOptions;
import io.lettuce.core.event.metrics.DefaultCommandLatencyEventPublisher;
import io.lettuce.core.event.metrics.MetricEventPublisher;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.metrics.CommandLatencyCollector;
import io.lettuce.core.metrics.CommandLatencyCollectorOptions;
import io.lettuce.core.metrics.DefaultCommandLatencyCollector;
import io.lettuce.core.metrics.DefaultCommandLatencyCollectorOptions;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultEventLoopGroupProvider;
import io.lettuce.core.resource.DefaultNettyCustomizer;
import io.lettuce.core.resource.Delay;
import io.lettuce.core.resource.DnsResolver;
import io.lettuce.core.resource.DnsResolvers;
import io.lettuce.core.resource.EventLoopGroupProvider;
import io.lettuce.core.resource.Futures;
import io.lettuce.core.resource.NettyCustomizer;
import io.lettuce.core.resource.SocketAddressResolver;
import io.lettuce.core.tracing.Tracing;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import reactor.core.scheduler.Schedulers;

public class DWDefaultClientResources
implements ClientResources {
    protected static final InternalLogger logger;
    public static final int MIN_IO_THREADS = 2;
    public static final int MIN_COMPUTATION_THREADS = 2;
    public static final int DEFAULT_IO_THREADS;
    public static final int DEFAULT_COMPUTATION_THREADS;
    public static final Supplier<Delay> DEFAULT_RECONNECT_DELAY;
    public static final NettyCustomizer DEFAULT_NETTY_CUSTOMIZER;
    private final boolean sharedEventLoopGroupProvider;
    private final EventLoopGroupProvider eventLoopGroupProvider;
    private final boolean sharedEventExecutor;
    private final EventExecutorGroup eventExecutorGroup;
    private final Timer timer;
    private final boolean sharedTimer;
    private final EventBus eventBus;
    private final CommandLatencyCollector commandLatencyCollector;
    private final boolean sharedCommandLatencyCollector;
    private final EventPublisherOptions commandLatencyPublisherOptions;
    private final MetricEventPublisher metricEventPublisher;
    private final DnsResolver dnsResolver;
    private final SocketAddressResolver socketAddressResolver;
    private final Supplier<Delay> reconnectDelay;
    private final NettyCustomizer nettyCustomizer;
    private final Tracing tracing;
    private volatile boolean shutdownCalled = false;

    protected DWDefaultClientResources(Builder builder) {
        if (builder.eventLoopGroupProvider == null) {
            int ioThreadPoolSize = builder.ioThreadPoolSize;
            if (ioThreadPoolSize < 2) {
                logger.info("ioThreadPoolSize is less than {} ({}), setting to: {}", new Object[]{2, ioThreadPoolSize, 2});
                ioThreadPoolSize = 2;
            }
            this.sharedEventLoopGroupProvider = false;
            this.eventLoopGroupProvider = new DefaultEventLoopGroupProvider(ioThreadPoolSize);
        } else {
            this.sharedEventLoopGroupProvider = builder.sharedEventLoopGroupProvider;
            this.eventLoopGroupProvider = builder.eventLoopGroupProvider;
        }
        if (builder.eventExecutorGroup == null) {
            int computationThreadPoolSize = builder.computationThreadPoolSize;
            if (computationThreadPoolSize < 2) {
                logger.info("computationThreadPoolSize is less than {} ({}), setting to: {}", new Object[]{2, computationThreadPoolSize, 2});
                computationThreadPoolSize = 2;
            }
            this.eventExecutorGroup = DefaultEventLoopGroupProvider.createEventLoopGroup(DefaultEventExecutorGroup.class, (int)computationThreadPoolSize);
            this.sharedEventExecutor = false;
        } else {
            this.sharedEventExecutor = builder.sharedEventExecutor;
            this.eventExecutorGroup = builder.eventExecutorGroup;
        }
        if (builder.timer == null) {
            this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("lettuce-timer"));
            this.sharedTimer = false;
        } else {
            this.timer = builder.timer;
            this.sharedTimer = builder.sharedTimer;
        }
        this.eventBus = builder.eventBus == null ? new DefaultEventBus(Schedulers.fromExecutor((Executor)this.eventExecutorGroup)) : builder.eventBus;
        if (builder.commandLatencyCollector == null) {
            if (DefaultCommandLatencyCollector.isAvailable()) {
                this.commandLatencyCollector = builder.commandLatencyCollectorOptions != null ? CommandLatencyCollector.create((CommandLatencyCollectorOptions)builder.commandLatencyCollectorOptions) : CommandLatencyCollector.create((CommandLatencyCollectorOptions)CommandLatencyCollectorOptions.create());
            } else {
                logger.debug("LatencyUtils/HdrUtils are not available, metrics are disabled");
                builder.commandLatencyCollectorOptions = CommandLatencyCollectorOptions.disabled();
                this.commandLatencyCollector = CommandLatencyCollector.disabled();
            }
            this.sharedCommandLatencyCollector = false;
        } else {
            this.sharedCommandLatencyCollector = builder.sharedCommandLatencyCollector;
            this.commandLatencyCollector = builder.commandLatencyCollector;
        }
        this.commandLatencyPublisherOptions = builder.commandLatencyPublisherOptions;
        this.metricEventPublisher = this.commandLatencyCollector.isEnabled() && this.commandLatencyPublisherOptions != null ? new DefaultCommandLatencyEventPublisher(this.eventExecutorGroup, this.commandLatencyPublisherOptions, this.eventBus, this.commandLatencyCollector) : null;
        this.dnsResolver = builder.dnsResolver == null ? DnsResolvers.UNRESOLVED : builder.dnsResolver;
        this.socketAddressResolver = builder.socketAddressResolver == null ? SocketAddressResolver.create((DnsResolver)this.dnsResolver) : builder.socketAddressResolver;
        this.reconnectDelay = builder.reconnectDelay;
        this.nettyCustomizer = builder.nettyCustomizer;
        this.tracing = builder.tracing;
    }

    public static DWDefaultClientResources create() {
        return DWDefaultClientResources.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder mutate() {
        Builder builder = new Builder();
        builder.eventExecutorGroup(this.eventExecutorGroup()).timer(this.timer()).eventBus(this.eventBus()).commandLatencyCollector(this.commandLatencyCollector()).commandLatencyPublisherOptions(this.commandLatencyPublisherOptions()).dnsResolver(this.dnsResolver()).socketAddressResolver(this.socketAddressResolver()).reconnectDelay(this.reconnectDelay).nettyCustomizer(this.nettyCustomizer()).tracing(this.tracing());
        builder.sharedCommandLatencyCollector = this.sharedEventLoopGroupProvider;
        builder.sharedEventExecutor = this.sharedEventExecutor;
        builder.sharedEventLoopGroupProvider = this.sharedEventLoopGroupProvider;
        builder.sharedTimer = this.sharedTimer;
        return builder;
    }

    protected void finalize() throws Throwable {
        if (!this.shutdownCalled) {
            logger.warn(this.getClass().getName() + " was not shut down properly, shutdown() was not called before it's garbage-collected. Call shutdown() or shutdown(long,long,TimeUnit) ");
        }
        super.finalize();
    }

    public Future<Boolean> shutdown() {
        return this.shutdown(0L, 2L, TimeUnit.SECONDS);
    }

    public Future<Boolean> shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        logger.debug("Initiate shutdown ({}, {}, {})", new Object[]{quietPeriod, timeout, timeUnit});
        this.shutdownCalled = true;
        DefaultPromise voidPromise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        PromiseCombiner aggregator = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.shutdown();
        }
        if (!this.sharedTimer) {
            this.timer.stop();
        }
        if (!this.sharedCommandLatencyCollector) {
            this.commandLatencyCollector.shutdown();
        }
        aggregator.finish((Promise)voidPromise);
        return Futures.toBooleanPromise((Future)voidPromise);
    }

    public EventLoopGroupProvider eventLoopGroupProvider() {
        return this.eventLoopGroupProvider;
    }

    public EventExecutorGroup eventExecutorGroup() {
        return this.eventExecutorGroup;
    }

    public int ioThreadPoolSize() {
        return this.eventLoopGroupProvider.threadPoolSize();
    }

    public int computationThreadPoolSize() {
        return LettuceLists.newList((Iterator)this.eventExecutorGroup.iterator()).size();
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public Timer timer() {
        return this.timer;
    }

    public CommandLatencyCollector commandLatencyCollector() {
        return this.commandLatencyCollector;
    }

    public EventPublisherOptions commandLatencyPublisherOptions() {
        return this.commandLatencyPublisherOptions;
    }

    public DnsResolver dnsResolver() {
        return this.dnsResolver;
    }

    public SocketAddressResolver socketAddressResolver() {
        return this.socketAddressResolver;
    }

    public Delay reconnectDelay() {
        return this.reconnectDelay.get();
    }

    public NettyCustomizer nettyCustomizer() {
        return this.nettyCustomizer;
    }

    public Tracing tracing() {
        return this.tracing;
    }

    static {
        int threads;
        logger = InternalLoggerFactory.getInstance(DWDefaultClientResources.class);
        DEFAULT_RECONNECT_DELAY = Delay::exponential;
        DEFAULT_NETTY_CUSTOMIZER = DefaultNettyCustomizer.INSTANCE;
        DEFAULT_IO_THREADS = threads = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)Math.max(2, Runtime.getRuntime().availableProcessors())));
        DEFAULT_COMPUTATION_THREADS = threads;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)threads);
        }
    }

    public static class Builder
    implements ClientResources.Builder {
        private boolean sharedEventLoopGroupProvider;
        private boolean sharedEventExecutor;
        private boolean sharedTimer;
        private boolean sharedCommandLatencyCollector;
        private int ioThreadPoolSize = DEFAULT_IO_THREADS;
        private int computationThreadPoolSize = DEFAULT_COMPUTATION_THREADS;
        private EventExecutorGroup eventExecutorGroup;
        private EventLoopGroupProvider eventLoopGroupProvider;
        private Timer timer;
        private EventBus eventBus;
        private CommandLatencyCollectorOptions commandLatencyCollectorOptions = DefaultCommandLatencyCollectorOptions.create();
        private CommandLatencyCollector commandLatencyCollector;
        private EventPublisherOptions commandLatencyPublisherOptions = DefaultEventPublisherOptions.create();
        private DnsResolver dnsResolver = DnsResolvers.UNRESOLVED;
        private SocketAddressResolver socketAddressResolver;
        private Supplier<Delay> reconnectDelay = DEFAULT_RECONNECT_DELAY;
        private NettyCustomizer nettyCustomizer = DEFAULT_NETTY_CUSTOMIZER;
        private Tracing tracing = Tracing.disabled();

        private Builder() {
        }

        public Builder ioThreadPoolSize(int ioThreadPoolSize) {
            LettuceAssert.isTrue((ioThreadPoolSize > 0 ? 1 : 0) != 0, (String)"I/O thread pool size must be greater zero");
            this.ioThreadPoolSize = ioThreadPoolSize;
            return this;
        }

        public Builder eventLoopGroupProvider(EventLoopGroupProvider eventLoopGroupProvider) {
            LettuceAssert.notNull((Object)eventLoopGroupProvider, (String)"EventLoopGroupProvider must not be null");
            this.sharedEventLoopGroupProvider = true;
            this.eventLoopGroupProvider = eventLoopGroupProvider;
            return this;
        }

        public Builder computationThreadPoolSize(int computationThreadPoolSize) {
            LettuceAssert.isTrue((computationThreadPoolSize > 0 ? 1 : 0) != 0, (String)"Computation thread pool size must be greater zero");
            this.computationThreadPoolSize = computationThreadPoolSize;
            return this;
        }

        public Builder eventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
            LettuceAssert.notNull((Object)eventExecutorGroup, (String)"EventExecutorGroup must not be null");
            this.sharedEventExecutor = true;
            this.eventExecutorGroup = eventExecutorGroup;
            return this;
        }

        public Builder timer(Timer timer) {
            LettuceAssert.notNull((Object)timer, (String)"Timer must not be null");
            this.sharedTimer = true;
            this.timer = timer;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            LettuceAssert.notNull((Object)eventBus, (String)"EventBus must not be null");
            this.eventBus = eventBus;
            return this;
        }

        public Builder commandLatencyPublisherOptions(EventPublisherOptions commandLatencyPublisherOptions) {
            LettuceAssert.notNull((Object)commandLatencyPublisherOptions, (String)"EventPublisherOptions must not be null");
            this.commandLatencyPublisherOptions = commandLatencyPublisherOptions;
            return this;
        }

        public Builder commandLatencyCollectorOptions(CommandLatencyCollectorOptions commandLatencyCollectorOptions) {
            LettuceAssert.notNull((Object)commandLatencyCollectorOptions, (String)"CommandLatencyCollectorOptions must not be null");
            this.commandLatencyCollectorOptions = commandLatencyCollectorOptions;
            return this;
        }

        public Builder commandLatencyCollector(CommandLatencyCollector commandLatencyCollector) {
            LettuceAssert.notNull((Object)commandLatencyCollector, (String)"CommandLatencyCollector must not be null");
            this.sharedCommandLatencyCollector = true;
            this.commandLatencyCollector = commandLatencyCollector;
            return this;
        }

        public ClientResources.Builder socketAddressResolver(SocketAddressResolver socketAddressResolver) {
            LettuceAssert.notNull((Object)socketAddressResolver, (String)"SocketAddressResolver must not be null");
            this.socketAddressResolver = socketAddressResolver;
            return this;
        }

        public Builder dnsResolver(DnsResolver dnsResolver) {
            LettuceAssert.notNull((Object)dnsResolver, (String)"DnsResolver must not be null");
            this.dnsResolver = dnsResolver;
            return this;
        }

        public Builder reconnectDelay(Delay reconnectDelay) {
            LettuceAssert.notNull((Object)reconnectDelay, (String)"Delay must not be null");
            LettuceAssert.isTrue((!(reconnectDelay instanceof Delay.StatefulDelay) ? 1 : 0) != 0, (String)"Delay must be a stateless instance.");
            return this.reconnectDelay(() -> reconnectDelay);
        }

        public Builder reconnectDelay(Supplier<Delay> reconnectDelay) {
            LettuceAssert.notNull(reconnectDelay, (String)"Delay must not be null");
            this.reconnectDelay = reconnectDelay;
            return this;
        }

        public Builder nettyCustomizer(NettyCustomizer nettyCustomizer) {
            LettuceAssert.notNull((Object)nettyCustomizer, (String)"NettyCustomizer must not be null");
            this.nettyCustomizer = nettyCustomizer;
            return this;
        }

        public Builder tracing(Tracing tracing) {
            LettuceAssert.notNull((Object)tracing, (String)"Tracing must not be null");
            this.tracing = tracing;
            return this;
        }

        public DWDefaultClientResources build() {
            return new DWDefaultClientResources(this);
        }
    }
}

