/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redisson.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.redisson.service.DWRedissonLock;
import com.digiwin.app.redisson.service.impl.DWFairLockImpl;
import com.digiwin.app.redisson.service.impl.DWLockImpl;
import com.digiwin.app.redisson.service.impl.DWReadWriteLock;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.core.RedisTemplate;

public class DWRedissonLockGenerator {
    protected RedissonClient redissonClient = null;
    protected RedisTemplate redisTemplate = null;

    public DWRedissonLockGenerator(RedissonClient redissonClient, RedisTemplate redisTemplate) {
        this.redissonClient = redissonClient;
        this.redisTemplate = redisTemplate;
    }

    public DWRedissonLock generateLock(String lockName) throws DWBusinessException {
        return this.generateLock(lockName, -1L, -1L, TimeUnit.SECONDS);
    }

    public DWRedissonLock generateLock(String lockName, long leaseTime, long waitTime, TimeUnit unit) throws DWBusinessException {
        return new DWLockImpl(lockName, leaseTime, waitTime, unit, this.redissonClient, this.redisTemplate);
    }

    public DWRedissonLock generateFairLock(String lockName) throws DWBusinessException {
        return this.generateFairLock(lockName, -1L, -1L, TimeUnit.SECONDS);
    }

    public DWRedissonLock generateFairLock(String lockName, long leaseTime, long waitTime, TimeUnit unit) throws DWBusinessException {
        return new DWFairLockImpl(lockName, leaseTime, waitTime, unit, this.redissonClient, this.redisTemplate);
    }

    public DWReadWriteLock generateReadWriteLock(String lockName) {
        return new DWReadWriteLock(lockName, this.redissonClient, this.redisTemplate);
    }
}

