/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redisson.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.redisson.service.DWRedissonLock;
import com.digiwin.app.redisson.service.impl.DWLockImpl;
import org.redisson.RedissonReadWriteLock;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.core.RedisTemplate;

public class DWReadWriteLock {
    RedissonReadWriteLock readWriteLock;
    RedissonClient redissonClient;
    RedisTemplate redisTemplate;

    public DWReadWriteLock(String lockName, RedissonClient redissonClient, RedisTemplate redisTemplate) {
        this.readWriteLock = (RedissonReadWriteLock)redissonClient.getReadWriteLock(lockName);
        this.redissonClient = redissonClient;
        this.redisTemplate = redisTemplate;
    }

    public DWRedissonLock readLock() throws DWBusinessException {
        DWLockImpl lock = new DWLockImpl(this.readWriteLock.getRawName(), this.redissonClient, this.redisTemplate);
        lock.lock = this.readWriteLock.readLock();
        return lock;
    }

    public DWRedissonLock writeLock() throws DWBusinessException {
        DWLockImpl lock = new DWLockImpl(this.readWriteLock.getRawName(), this.redissonClient, this.redisTemplate);
        lock.lock = this.readWriteLock.writeLock();
        return lock;
    }
}

