/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redisson.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.redisson.service.IDWRedissonPrefix;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public class DWAppRedissonPrefix
implements IDWRedissonPrefix {
    public static final String BEAN_NAME = "redisson-lock-prefix-app";
    protected Environment environment;
    protected boolean checkFlag;

    public DWAppRedissonPrefix(Environment environment) {
        this.environment = environment;
        this.checkFlag = Boolean.parseBoolean(environment.getProperty("dap.redisson.generate.prefix.check.enabled", "false"));
    }

    @Override
    public String getLockName(String name, String lockType) throws DWBusinessException {
        String prefix = this.getPrefix();
        String string = prefix = StringUtils.isEmpty((CharSequence)prefix) ? "" : prefix + ":";
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{lockType})) {
            return prefix + lockType + ":" + name;
        }
        return prefix + name;
    }

    protected String getPrefix() throws DWBusinessException {
        String appId = this.environment.getProperty("appId");
        if (this.checkFlag && StringUtils.isEmpty((CharSequence)appId)) {
            throw new DWBusinessException("\u751f\u6210\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff0cappId\u4e3a\u7a7a");
        }
        return appId;
    }
}

