/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.exceptions;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;

public abstract class DWI18NExceptionUtils {
    public static void throwDWException(String errorCode, Object ... params) throws DWException {
        throw DWI18NExceptionUtils.createDWException(null, errorCode, params);
    }

    public static void throwDWException(Throwable cause, String errorCode, Object ... params) throws DWException {
        throw DWI18NExceptionUtils.createDWException(cause, errorCode, params);
    }

    private static DWException createDWException(Throwable cause, String errorCode, Object ... params) {
        String message = DWApplicationMessageResourceBundleUtils.getString(errorCode, params);
        DWException exception = new DWException(errorCode, message, cause);
        return exception;
    }

    public static void throwDWBusinessException(String errorCode, Object ... params) throws DWBusinessException {
        throw DWI18NExceptionUtils.createDWBusinessException(null, errorCode, params);
    }

    public static void throwDWBusinessException(Throwable cause, String errorCode, Object ... params) throws DWBusinessException {
        throw DWI18NExceptionUtils.createDWBusinessException(cause, errorCode, params);
    }

    public static DWBusinessException createDWBusinessException(Throwable cause, String errorCode, Object ... params) throws DWBusinessException {
        String message = DWApplicationMessageResourceBundleUtils.getString(errorCode, params);
        DWBusinessException exception = new DWBusinessException(errorCode, message, cause);
        return exception;
    }

    public static void throwDWArgumentException(String focusTarget, String errorCode, Object ... params) throws DWArgumentException {
        throw DWI18NExceptionUtils.createDWArgumentException(null, focusTarget, errorCode, params);
    }

    public static void throwDWArgumentException(Throwable cause, String focusTarget, String errorCode, Object ... params) throws DWArgumentException {
        throw DWI18NExceptionUtils.createDWArgumentException(cause, focusTarget, errorCode, params);
    }

    public static DWArgumentException createDWArgumentException(Throwable cause, String focusTarget, String errorCode, Object ... params) throws DWArgumentException {
        String message = DWApplicationMessageResourceBundleUtils.getString(errorCode, params);
        DWArgumentException exception = new DWArgumentException(focusTarget, message, cause);
        return exception;
    }
}

