/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.resource;

import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.resource.DWResourceBundleUtils;

public class DWApplicationResourceBundleUtils {
    public static String getString(String baseName, String key, Object ... patternArguments) {
        return DWApplicationResourceBundleUtils.getStringWithDefaultMessage(true, baseName, key, null, patternArguments);
    }

    public static String getStringWithDefaultMessage(boolean generateNotFoudMessage, String baseName, String code, String defaultMessage, Object[] args) {
        String result = ConfigPool.getInstance().getApplicationString(baseName, code, args);
        if (result == null) {
            result = DWApplicationResourceBundleUtils.getPlatformString(baseName, code, args);
        }
        if (result == null) {
            if (defaultMessage != null) {
                result = defaultMessage;
            } else if (generateNotFoudMessage) {
                result = DWResourceBundleUtils.getNotFoundString(baseName, code);
            }
        }
        return result;
    }

    public static String getPlatformString(String baseName, String key, Object ... patternArguments) {
        return ConfigPool.getInstance().getPlatformString(baseName, key, patternArguments);
    }

    @Deprecated
    public static String getResourceBundle(String baseName, String key, String defaultValue, Object ... patternArguments) {
        String result = null;
        String notFoundMark = "$arbNotFound$";
        DWApplicationClassLoader applicationClassLoader = DWApplicationClassLoader.getInstance();
        result = DWResourceBundleUtils.getResourceBundle((ClassLoader)applicationClassLoader, baseName, key, notFoundMark, patternArguments);
        if (notFoundMark.equals(result)) {
            result = DWApplicationResourceBundleUtils.getPlatformResourceBundle(baseName, key, defaultValue, patternArguments);
        }
        return result;
    }

    @Deprecated
    public static String getPlatformResourceBundle(String baseName, String key, String defaultValue, Object ... patternArguments) {
        ClassLoader platformClassLoader = DWApplicationClassLoader.getInstance().getPlatformClassLoader();
        return DWResourceBundleUtils.getResourceBundle(platformClassLoader, baseName, key, defaultValue, patternArguments);
    }
}

