/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.http;

import com.digiwin.app.http.HttpRequestModel;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpConnectionManager {
    public static CloseableHttpClient httpClient;

    public static synchronized void init(HttpRequestModel requestModel) {
        if (httpClient == null) {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(requestModel.getMaxTotalConnections());
            connectionManager.setMaxTotal(requestModel.getMaxTotalConnections());
            RequestConfig config = RequestConfig.custom().setSocketTimeout(requestModel.getSoTimeout()).setConnectTimeout(requestModel.getConnectionTimeout()).setConnectionRequestTimeout(requestModel.getConnectionPoolRequestTimeout()).build();
            httpClient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
    }

    public static CloseableHttpClient getHttpClient(HttpRequestModel requestModel) {
        if (httpClient == null) {
            HttpConnectionManager.init(requestModel);
        }
        return httpClient;
    }
}

