/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.http;

import com.digiwin.app.http.HttpConnectionManager;
import com.digiwin.app.http.HttpRequestLogModel;
import com.digiwin.app.http.HttpRequestLogger;
import com.digiwin.app.http.HttpRequestModel;
import com.digiwin.app.http.HttpResponseModel;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpRequester {
    public static HttpResponseModel submitRequest(HttpRequestModel requestModel) throws Exception {
        HttpRequestLogModel logModel = new HttpRequestLogModel();
        logModel.setUrl(requestModel.getUrl());
        logModel.setRequestHeader(requestModel.getRequestHeader());
        logModel.setRequestBody(requestModel.getRequestBody());
        CloseableHttpClient client = HttpConnectionManager.getHttpClient(requestModel);
        HttpPost post = new HttpPost(requestModel.getUrl());
        StringEntity requestEntity = new StringEntity(requestModel.getRequestBody(), "utf-8");
        requestEntity.setContentType(requestModel.getContentType());
        requestEntity.setContentEncoding(requestModel.getEncode());
        post.setEntity((HttpEntity)requestEntity);
        for (Map.Entry<String, String> header : requestModel.getRequestHeader().entrySet()) {
            post.addHeader(header.getKey(), header.getValue());
        }
        logModel.setStartTime(LocalDateTime.now());
        String responseBody = "";
        int httpStatusCode = -1;
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
            httpStatusCode = response.getStatusLine().getStatusCode();
            try (InputStream responseStream = response.getEntity().getContent();){
                if (responseStream != null) {
                    responseBody = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
                }
            }
        }
        logModel.setEndTime(LocalDateTime.now());
        logModel.setResponseBody(responseBody);
        logModel.setHttpStatusCode(httpStatusCode);
        HttpRequestLogger.log(logModel);
        HttpResponseModel responseModel = new HttpResponseModel(httpStatusCode, responseBody);
        return responseModel;
    }
}

