/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.http;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.http.DWRestfulContainerFuse;
import com.digiwin.app.http.HttpConnectionManager;
import com.digiwin.app.http.HttpRequestLogModel;
import com.digiwin.app.http.HttpRequestLogger;
import com.digiwin.app.http.HttpRequestModel;
import com.digiwin.app.http.HttpResponseModel;
import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.config.DapPropertiesOptionKey;
import com.digiwin.gateway.fuse.config.DapPropertiesOutboundKey;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfigBuilder;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.context.ApplicationContext;

public class HttpRequester {
    private static Log log = LogFactory.getLog(HttpRequester.class);

    public static HttpResponseModel submitRequest(HttpRequestModel requestModel) throws Exception {
        HttpRequestLogModel logModel = new HttpRequestLogModel();
        logModel.setUrl(requestModel.getUrl());
        logModel.setRequestHeader(requestModel.getRequestHeader());
        logModel.setRequestBody(requestModel.getRequestBody());
        CloseableHttpClient client = HttpConnectionManager.getHttpClient(requestModel);
        HttpPost post = new HttpPost(requestModel.getUrl());
        StringEntity requestEntity = new StringEntity(requestModel.getRequestBody(), "utf-8");
        requestEntity.setContentType(requestModel.getContentType());
        requestEntity.setContentEncoding(requestModel.getEncode());
        post.setEntity((HttpEntity)requestEntity);
        for (Map.Entry<String, String> header : requestModel.getRequestHeader().entrySet()) {
            post.addHeader(header.getKey(), header.getValue());
        }
        logModel.setStartTime(LocalDateTime.now());
        OutboundConfig outboundConfig = HttpRequester.getOutboundConfig();
        CollectorRegistry collectorRegistry = null;
        try {
            ApplicationContext applicationContext = DWApplicationSpringUtils.getContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[DWRestfulContainer] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[DWRestfulContainer] collectorRegistry: " + stackTrace));
        }
        outboundConfig.setCollectorRegistry(collectorRegistry);
        DWRestfulContainerFuse restfulContainerFuse = new DWRestfulContainerFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("client", (Object)client);
        fuseParameter.set("post", (Object)post);
        DWFuseReturnResponse fuseReturn = new DWFuseReturnResponse((Object)new HttpResponseModel(-1, ""));
        DWFuseOption option = HttpRequester.getOption();
        option.setAutoFuseHttpStatusCode(false);
        log.debug((Object)("[DWRestfulContainer] option: " + option));
        fuseReturn = DWFuseExecutor.execute((DWReturnFuse)restfulContainerFuse, (DWFuseParameter)fuseParameter, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        HttpResponseModel response = (HttpResponseModel)fuseReturn.getResponse();
        String responseBody = response.getResponseBody();
        int httpStatusCode = response.getHttpStatusCode();
        logModel.setEndTime(LocalDateTime.now());
        logModel.setResponseBody(responseBody);
        logModel.setHttpStatusCode(httpStatusCode);
        HttpRequestLogger.log(logModel);
        HttpResponseModel responseModel = new HttpResponseModel(httpStatusCode, responseBody);
        return responseModel;
    }

    private static DWFuseOption getOption() {
        String isIgnoreUnassignedXRateLimitHeaderKey = DapPropertiesOptionKey.isIgnoreUnassignedXRateLimitHeader();
        String isXRateLimitHeaderOnKey = DapPropertiesOptionKey.isXRateLimitHeaderOn();
        String isCollectMetricsKey = DapPropertiesOptionKey.isCollectMetrics();
        String isAutoFuseHttpStatusCodeKey = DapPropertiesOptionKey.isAutoFuseHttpStatusCode();
        String inboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.inboundErrorHttpStatusCode();
        String outboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.outboundErrorHttpStatusCode();
        String isIgnoreUnassignedXRateLimitHeader = DWApplicationConfigUtils.getProperty((String)isIgnoreUnassignedXRateLimitHeaderKey, (String)String.valueOf(true));
        String isXRateLimitHeaderOn = DWApplicationConfigUtils.getProperty((String)isXRateLimitHeaderOnKey, (String)String.valueOf(true));
        String isCollectMetrics = DWApplicationConfigUtils.getProperty((String)isCollectMetricsKey, (String)String.valueOf(false));
        String isAutoFuseHttpStatusCode = DWApplicationConfigUtils.getProperty((String)isAutoFuseHttpStatusCodeKey, (String)String.valueOf(true));
        String inboundErrorHttpStatusCode = DWApplicationConfigUtils.getProperty((String)inboundErrorHttpStatusCodeKey, (String)String.valueOf(429));
        String outboundErrorHttpStatusCode = DWApplicationConfigUtils.getProperty((String)outboundErrorHttpStatusCodeKey, (String)String.valueOf(503));
        DWFuseOption option = new DWFuseOption();
        option.setIgnoreUnassignedXRateLimitHeader(isIgnoreUnassignedXRateLimitHeader);
        option.setXRateLimitHeaderOn(isXRateLimitHeaderOn);
        option.setCollectMetrics(isCollectMetrics);
        option.setAutoFuseHttpStatusCode(isAutoFuseHttpStatusCode);
        option.setInboundErrorHttpStatusCode(inboundErrorHttpStatusCode);
        option.setOutboundErrorHttpStatusCode(outboundErrorHttpStatusCode);
        return option;
    }

    private static OutboundConfig getOutboundConfig() {
        String key = "restfulContainer";
        String enableKey = DapPropertiesOutboundKey.enable((String)key);
        String failureRateKey = DapPropertiesOutboundKey.failureRate((String)key);
        String openSecKey = DapPropertiesOutboundKey.openSec((String)key);
        String halfOpenCalculateSizeKey = DapPropertiesOutboundKey.halfOpenCalculateSize((String)key);
        String closeCalculateSizeKey = DapPropertiesOutboundKey.closeCalculateSize((String)key);
        String enable = DWApplicationConfigUtils.getProperty((String)enableKey, (String)"false");
        String failureRate = DWApplicationConfigUtils.getProperty((String)failureRateKey, (String)String.valueOf(50));
        String openSec = DWApplicationConfigUtils.getProperty((String)openSecKey, (String)String.valueOf(60));
        String halfOpenCalculateSize = DWApplicationConfigUtils.getProperty((String)halfOpenCalculateSizeKey, (String)String.valueOf(10));
        String closeCalculateSize = DWApplicationConfigUtils.getProperty((String)closeCalculateSizeKey, (String)String.valueOf(100));
        OutboundConfig outboundConfig = new OutboundConfigBuilder(key).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        return outboundConfig;
    }
}

