/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.job;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.schedule.entity.DWJobResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class DWJobInvoker
implements Job,
InterruptableJob {
    private static boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    private static String tenantColumnName = DWTenantUtils.getTenantColumnName();
    private static String IAM_TENANTSID = "tenantSid";
    private static String IAM_USERID = "userId";
    private static String _SCHEDULEID = "schedule";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String moduleName = jobDataMap.getString("module_name");
        String serviceName = jobDataMap.getString("job_name");
        Map paramMap = (Map)jobDataMap.get((Object)"schedule_param");
        if (StringUtils.isEmpty((CharSequence)moduleName) || StringUtils.isEmpty((CharSequence)serviceName)) {
            throw new JobExecutionException("\u8a2d\u5b9a\u7570\u5e38");
        }
        DWDefaultParameters parameters = new DWDefaultParameters();
        DWContainerContext containerContext = DWContainerContext.getInstance();
        Map<String, Object> profile = new HashMap<String, String>();
        if (tenantEnabled) {
            profile = DWServiceContext.getContext().getProfile();
            if (profile == null || !profile.containsKey(IAM_TENANTSID)) {
                profile = new HashMap();
                if (jobDataMap.containsKey((Object)tenantColumnName)) {
                    profile.put(IAM_TENANTSID, jobDataMap.get((Object)tenantColumnName));
                }
                if (jobDataMap.containsKey((Object)"tenantId")) {
                    String tenantId = String.valueOf(jobDataMap.get((Object)"tenantId"));
                    profile.put("tenantId", tenantId);
                }
                if (jobDataMap.containsKey((Object)"dw_schedule_exec_userid") && jobDataMap.get((Object)"dw_schedule_exec_userid") != null) {
                    profile.put(IAM_USERID, jobDataMap.get((Object)"dw_schedule_exec_userid"));
                } else {
                    profile.put(IAM_USERID, _SCHEDULEID);
                }
            }
        } else {
            profile.put(IAM_USERID, _SCHEDULEID);
        }
        profile.put("secretKey", jobDataMap.getString("secretKey"));
        parameters.put("paramMap", (Object)paramMap);
        try {
            DWJobResult result = (DWJobResult)containerContext.invoke(moduleName, serviceName, "executeJob", (DWParameters)parameters, profile);
            jobDataMap.put("execute_status", result == null ? "" : result.getExecuteStatus());
            jobDataMap.put("message", result == null ? "" : result.getMessage());
            jobDataMap.put("message_detail", result == null ? "" : result.getMessageDetail());
        }
        catch (Exception e) {
            Throwable exception = this.getCause(e);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            String exeErrorDetailMsg = stringWriter.toString();
            jobDataMap.put("execute_status", "error");
            jobDataMap.put("message", exception.getMessage());
            jobDataMap.put("message_detail", exeErrorDetailMsg);
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
    }

    private Throwable getCause(Throwable e) {
        Throwable cause = null;
        Throwable result = e;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }
}

