/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.dbservice;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.util.DWScheduleCastUtils;
import com.digiwin.utils.DWTenantUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DWScheduleDBService {
    @Autowired
    private DWDao dao;
    private static String tenantSqlTag = DWTenantUtils.getTenantTagByColumnName();
    private final String querySQL = "select * from dw_schedule ";
    private final String updateSQL = "update  from dw_schedule ";
    private final String deleteSQL = "delete from dw_schedule where schedule_id = ? " + tenantSqlTag;
    private final String updateStatusSQL = "update dw_schedule set enable_status = ? where schedule_id = ? " + tenantSqlTag;
    private static DWScheduleDBService instance = null;

    public static DWScheduleDBService getInstance() {
        if (instance == null) {
            instance = (DWScheduleDBService)SpringContextUtils.getBean((String)"DWScheduleDBService");
        }
        return instance;
    }

    public Object updateScheduleByDataSet(DWDataSet dataSet) throws Exception {
        return this.dao.execute(dataSet);
    }

    public int deleteSchedule(String scheduleId) throws Exception {
        return this.dao.update(this.deleteSQL, new Object[]{scheduleId});
    }

    public Object getScheduleList(DWPagableQueryInfo queryInfo) throws Exception {
        return this.dao.select((DWQueryInfo)queryInfo, "select * from dw_schedule ");
    }

    public DWDataRow getScheduleInfo(String scheduleId) throws Exception {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.addEqualInfo("schedule_id", (Object)scheduleId);
        return this.dao.selectOne(queryInfo, "select * from dw_schedule ");
    }

    public int enableSchedule(String id) throws Exception {
        return this.dao.update(this.updateStatusSQL, new Object[]{"Y", id});
    }

    public int disableSchedule(String id) throws Exception {
        return this.dao.update(this.updateStatusSQL, new Object[]{"N", id});
    }

    public DWScheduleQuartzInfo queryDWScheduleQuartzInfo(String scheduleId) throws Exception {
        DWScheduleQuartzInfo quartzInfo = null;
        DWDataRow scheduleInfo = this.getScheduleInfo(scheduleId);
        if (scheduleInfo != null) {
            quartzInfo = DWScheduleCastUtils.convertDataRowToScheduleQuartzInfo(scheduleInfo);
        }
        return quartzInfo;
    }
}

