/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.dbservice;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.utils.DWTenantUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DWScheduleRecordDBService {
    @Autowired
    private DWDao dao;
    private static String tenantSqlTag = DWTenantUtils.getTenantTagByColumnName();
    private final String querySQL = "select * from dw_schedule_record";
    private final String updateStatusSQL = "update dw_schedule_record set execute_state = ? where execute_id = ? " + tenantSqlTag;
    private final String updateTimeSQL = "update dw_schedule_record set end_time = ? ,execute_state = ?  where execute_id = ? " + tenantSqlTag;
    private static DWScheduleRecordDBService instance = null;

    public static DWScheduleRecordDBService getInstance() {
        if (instance == null && SpringContextUtils.containsBean((String)"DWScheduleRecordDBService")) {
            instance = (DWScheduleRecordDBService)SpringContextUtils.getBean((String)"DWScheduleRecordDBService");
        }
        return instance;
    }

    public Object updateByDataSet(DWDataSet dataSet) throws Exception {
        return this.dao.execute(dataSet);
    }

    public Object getResultList(DWPagableQueryInfo queryInfo) throws Exception {
        return this.dao.selectWithPage(queryInfo, "select * from dw_schedule_record");
    }

    public Object getResult(DWPagableQueryInfo queryInfo) throws Exception {
        return this.dao.select((DWQueryInfo)queryInfo, "select * from dw_schedule_record");
    }

    public int updateStatus(String id, String status) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.updateStatusSQL, new Object[]{status, id});
    }

    public int updateStatusAndEndTime(String id, String status, Object time) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.updateTimeSQL, new Object[]{time, status, id});
    }
}

