/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.delegate;

import com.digiwin.app.schedule.quartz.delegate.RecurrenceRulePersistenceDelegate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.spi.OperableTrigger;

public class DWStdJDBCDelegate
extends StdJDBCDelegate {
    private static final String SELECT_HAS_DWMISFIRED_TRIGGERS_IN_STATE = "SELECT TRIGGER_NAME, TRIGGER_GROUP, NEXT_FIRE_TIME FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND TRIGGER_STATE = ?  ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC";
    private static final String SELECT_RETRY_AFTER_MISFIRE_SEC = "SELECT schedule_id, retry_after_misfire_sec FROM dw_schedule_time";

    protected void addDefaultTriggerPersistenceDelegates() {
        super.addDefaultTriggerPersistenceDelegates();
        this.addTriggerPersistenceDelegate((TriggerPersistenceDelegate)new RecurrenceRulePersistenceDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTrigger(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        PreparedStatement ps;
        block11: {
            boolean updateJobData = trigger.getJobDataMap().isDirty();
            ByteArrayOutputStream baos = null;
            updateJobData = true;
            if (updateJobData) {
                JobDataMap jobDataMap = trigger.getJobDataMap();
                JobDataMap jobDataMapToDb = new JobDataMap();
                for (Map.Entry entry : jobDataMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    jobDataMapToDb.put(key, value);
                }
                jobDataMapToDb.put("is_misfire", "false");
                baos = this.serializeJobData(jobDataMapToDb);
            }
            ps = null;
            insertResult = 0;
            try {
                ps = updateJobData ? conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ?, JOB_DATA = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?")) : conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, trigger.getJobKey().getName());
                ps.setString(2, trigger.getJobKey().getGroup());
                ps.setString(3, trigger.getDescription());
                long nextFireTime = -1L;
                if (trigger.getNextFireTime() != null) {
                    nextFireTime = trigger.getNextFireTime().getTime();
                }
                ps.setBigDecimal(4, new BigDecimal(String.valueOf(nextFireTime)));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(5, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(6, state);
                TriggerPersistenceDelegate tDel = this.findTriggerPersistenceDelegate(trigger);
                String type = "BLOB";
                if (tDel != null) {
                    type = tDel.getHandledTriggerTypeDiscriminator();
                }
                ps.setString(7, type);
                ps.setBigDecimal(8, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(9, new BigDecimal(String.valueOf(endTime)));
                ps.setString(10, trigger.getCalendarName());
                ps.setInt(11, trigger.getMisfireInstruction());
                ps.setInt(12, trigger.getPriority());
                if (updateJobData) {
                    this.setBytes(ps, 13, baos);
                    ps.setString(14, trigger.getKey().getName());
                    ps.setString(15, trigger.getKey().getGroup());
                } else {
                    ps.setString(13, trigger.getKey().getName());
                    ps.setString(14, trigger.getKey().getGroup());
                }
                insertResult = ps.executeUpdate();
                if (tDel == null) {
                    this.updateBlobTrigger(conn, trigger);
                    break block11;
                }
                tDel.updateExtendedTriggerProperties(conn, trigger, state, jobDetail);
            }
            catch (Throwable throwable) {
                DWStdJDBCDelegate.closeStatement(ps);
                throw throwable;
            }
        }
        DWStdJDBCDelegate.closeStatement((Statement)ps);
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateMisfiredTrigger(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        PreparedStatement ps;
        block10: {
            boolean updateJobData = trigger.getJobDataMap().isDirty();
            ByteArrayOutputStream baos = null;
            updateJobData = true;
            if (updateJobData) {
                JobDataMap jobDataMap = trigger.getJobDataMap();
                String isMisfire = "true";
                jobDataMap.put("is_misfire", isMisfire);
                baos = this.serializeJobData(jobDataMap);
            }
            ps = null;
            insertResult = 0;
            try {
                ps = updateJobData ? conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ?, JOB_DATA = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?")) : conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, trigger.getJobKey().getName());
                ps.setString(2, trigger.getJobKey().getGroup());
                ps.setString(3, trigger.getDescription());
                long nextFireTime = -1L;
                if (trigger.getNextFireTime() != null) {
                    nextFireTime = trigger.getNextFireTime().getTime();
                }
                ps.setBigDecimal(4, new BigDecimal(String.valueOf(nextFireTime)));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(5, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(6, state);
                TriggerPersistenceDelegate tDel = this.findTriggerPersistenceDelegate(trigger);
                String type = "BLOB";
                if (tDel != null) {
                    type = tDel.getHandledTriggerTypeDiscriminator();
                }
                ps.setString(7, type);
                ps.setBigDecimal(8, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(9, new BigDecimal(String.valueOf(endTime)));
                ps.setString(10, trigger.getCalendarName());
                ps.setInt(11, trigger.getMisfireInstruction());
                ps.setInt(12, trigger.getPriority());
                if (updateJobData) {
                    this.setBytes(ps, 13, baos);
                    ps.setString(14, trigger.getKey().getName());
                    ps.setString(15, trigger.getKey().getGroup());
                } else {
                    ps.setString(13, trigger.getKey().getName());
                    ps.setString(14, trigger.getKey().getGroup());
                }
                insertResult = ps.executeUpdate();
                if (tDel == null) {
                    this.updateBlobTrigger(conn, trigger);
                    break block10;
                }
                tDel.updateExtendedTriggerProperties(conn, trigger, state, jobDetail);
            }
            catch (Throwable throwable) {
                DWStdJDBCDelegate.closeStatement(ps);
                throw throwable;
            }
        }
        DWStdJDBCDelegate.closeStatement((Statement)ps);
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertMisfiredTrigger(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        PreparedStatement ps;
        block9: {
            JobDataMap jobDataMap = trigger.getJobDataMap();
            String isMisfire = "true";
            jobDataMap.put("is_misfire", isMisfire);
            ByteArrayOutputStream baos = null;
            if (trigger.getJobDataMap().size() > 0) {
                baos = this.serializeJobData(trigger.getJobDataMap());
            }
            ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA, PRIORITY)  VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, trigger.getKey().getName());
                ps.setString(2, trigger.getKey().getGroup());
                ps.setString(3, trigger.getJobKey().getName());
                ps.setString(4, trigger.getJobKey().getGroup());
                ps.setString(5, trigger.getDescription());
                if (trigger.getNextFireTime() != null) {
                    ps.setBigDecimal(6, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
                } else {
                    ps.setBigDecimal(6, null);
                }
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(7, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(8, state);
                TriggerPersistenceDelegate tDel = this.findTriggerPersistenceDelegate(trigger);
                String type = "BLOB";
                if (tDel != null) {
                    type = tDel.getHandledTriggerTypeDiscriminator();
                }
                ps.setString(9, type);
                ps.setBigDecimal(10, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(11, new BigDecimal(String.valueOf(endTime)));
                ps.setString(12, trigger.getCalendarName());
                ps.setInt(13, trigger.getMisfireInstruction());
                this.setBytes(ps, 14, baos);
                ps.setInt(15, trigger.getPriority());
                insertResult = ps.executeUpdate();
                if (tDel == null) {
                    this.insertBlobTrigger(conn, trigger);
                    break block9;
                }
                tDel.insertExtendedTriggerProperties(conn, trigger, state, jobDetail);
            }
            catch (Throwable throwable) {
                DWStdJDBCDelegate.closeStatement(ps);
                throw throwable;
            }
        }
        DWStdJDBCDelegate.closeStatement((Statement)ps);
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDWMisfiredTriggersInState(Connection conn, String state1, long ts, int count, List<TriggerKey> resultList) throws SQLException {
        boolean bl;
        boolean hasReachedLimit;
        HashMap<String, Long> retryInfoMap;
        ResultSet dwResultSet;
        PreparedStatement dwPreparedStatement;
        ResultSet quartzResultSet;
        PreparedStatement quartzPreparedStatement;
        block7: {
            quartzPreparedStatement = null;
            quartzResultSet = null;
            dwPreparedStatement = null;
            dwResultSet = null;
            quartzPreparedStatement = conn.prepareStatement(this.rtp(SELECT_HAS_DWMISFIRED_TRIGGERS_IN_STATE));
            quartzPreparedStatement.setString(1, state1);
            quartzResultSet = quartzPreparedStatement.executeQuery();
            dwPreparedStatement = conn.prepareStatement(SELECT_RETRY_AFTER_MISFIRE_SEC);
            dwResultSet = dwPreparedStatement.executeQuery();
            retryInfoMap = new HashMap<String, Long>();
            while (dwResultSet.next()) {
                String scheduleId = dwResultSet.getString("schedule_id");
                Long retryAfterMisfireSec = dwResultSet.getLong("retry_after_misfire_sec");
                retryInfoMap.put(scheduleId, retryAfterMisfireSec);
            }
            hasReachedLimit = false;
            if (retryInfoMap.size() != 0) break block7;
            boolean retryAfterMisfireSec = hasReachedLimit;
            DWStdJDBCDelegate.closeResultSet((ResultSet)quartzResultSet);
            DWStdJDBCDelegate.closeStatement((Statement)quartzPreparedStatement);
            DWStdJDBCDelegate.closeResultSet((ResultSet)dwResultSet);
            DWStdJDBCDelegate.closeStatement((Statement)dwPreparedStatement);
            return retryAfterMisfireSec;
        }
        try {
            while (quartzResultSet.next() && !hasReachedLimit) {
                if (resultList.size() == count) {
                    hasReachedLimit = true;
                    continue;
                }
                String triggerName = quartzResultSet.getString("TRIGGER_NAME");
                String groupName = quartzResultSet.getString("TRIGGER_GROUP");
                Long nextFireTime = quartzResultSet.getLong("NEXT_FIRE_TIME");
                Long retryAfterMisfireSec = (Long)retryInfoMap.get(groupName);
                Long dwMisfireTime = ts;
                if (retryAfterMisfireSec != null) {
                    dwMisfireTime = this.getDWMisfireTime(retryAfterMisfireSec * 1000L);
                }
                if (nextFireTime >= dwMisfireTime) continue;
                resultList.add(TriggerKey.triggerKey((String)triggerName, (String)groupName));
            }
            bl = hasReachedLimit;
        }
        catch (Throwable throwable) {
            DWStdJDBCDelegate.closeResultSet(quartzResultSet);
            DWStdJDBCDelegate.closeStatement((Statement)quartzPreparedStatement);
            DWStdJDBCDelegate.closeResultSet(dwResultSet);
            DWStdJDBCDelegate.closeStatement(dwPreparedStatement);
            throw throwable;
        }
        DWStdJDBCDelegate.closeResultSet((ResultSet)quartzResultSet);
        DWStdJDBCDelegate.closeStatement((Statement)quartzPreparedStatement);
        DWStdJDBCDelegate.closeResultSet((ResultSet)dwResultSet);
        DWStdJDBCDelegate.closeStatement((Statement)dwPreparedStatement);
        return bl;
    }

    private Long getDWMisfireTime(Long misfireThreshold) {
        Long misfireTime = System.currentTimeMillis();
        if (misfireThreshold > 0L) {
            misfireTime = misfireTime - misfireThreshold;
        }
        return misfireTime > 0L ? misfireTime : 0L;
    }
}

