/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.triggers;

import biweekly.util.Recurrence;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Calendar;
import org.quartz.RecurrenceRuleScheduleBuilder;
import org.quartz.RecurrenceRuleTrigger;
import org.quartz.RecurrenceRuleUtils;
import org.quartz.ScheduleBuilder;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CoreTrigger;

public class RecurrenceRuleTriggerImpl
extends AbstractTrigger<RecurrenceRuleTrigger>
implements RecurrenceRuleTrigger,
CoreTrigger {
    private static final long serialVersionUID = 1233337060012692693L;
    private static final int YEAR_TO_GIVEUP_SCHEDULING_AT = java.util.Calendar.getInstance().get(1) + 100;
    private String recurrenceRuleExpression = null;
    private transient Recurrence recurrenceRule = null;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private Date fromDate = null;
    private int timesTriggered = 0;

    public RecurrenceRuleTriggerImpl() {
        this.setDescription("R_RULE_Trigger");
    }

    public Object clone() {
        RecurrenceRuleTriggerImpl copy = (RecurrenceRuleTriggerImpl)super.clone();
        if (this.getRecurrenceRuleExpression() != null) {
            try {
                copy.setRecurrenceRuleExpression(this.getRecurrenceRuleExpression());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return copy;
    }

    public void setRecurrenceRuleExpression(String rruleExpression) throws ParseException {
        this.recurrenceRuleExpression = rruleExpression;
        this.recurrenceRule = RecurrenceRuleUtils.parseRecurrenceRuleExpression(rruleExpression);
    }

    public void setRecurrenceRule(Recurrence rrule) {
        this.recurrenceRule = rrule;
        this.recurrenceRuleExpression = RecurrenceRuleUtils.generateRecurrenceRuleExpression(this.recurrenceRule);
    }

    @Override
    public Recurrence getRecurrenceRule() {
        if (this.recurrenceRule == null && StringUtils.isNotBlank((CharSequence)this.recurrenceRuleExpression)) {
            this.recurrenceRule = RecurrenceRuleUtils.parseRecurrenceRuleExpression(this.recurrenceRuleExpression);
        }
        return this.recurrenceRule;
    }

    @Override
    public String getRecurrenceRuleExpression() {
        if (StringUtils.isBlank((CharSequence)this.recurrenceRuleExpression) && this.recurrenceRule != null) {
            this.recurrenceRuleExpression = RecurrenceRuleUtils.generateRecurrenceRuleExpression(this.recurrenceRule);
        }
        return this.recurrenceRuleExpression;
    }

    public Date getStartTime() {
        return this.fromDate;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        java.util.Calendar cl = java.util.Calendar.getInstance();
        cl.setTime(startTime);
        cl.set(14, 0);
        this.fromDate = cl.getTime();
    }

    public Date getEndTime() {
        if (this.getRecurrenceRule() == null) {
            return null;
        }
        return this.getRecurrenceRule().getUntil();
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        if (endTime != null) {
            this.setRecurrenceRule(new Recurrence.Builder(this.getRecurrenceRule()).until(endTime).build());
        }
    }

    @Override
    public int getRepeatCount() {
        if (this.getRecurrenceRule() == null || this.getRecurrenceRule().getCount() == null) {
            return -1;
        }
        return this.getRecurrenceRule().getCount();
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setNextFireTime(Date fireTime) {
        this.nextFireTime = fireTime;
    }

    public void setPreviousFireTime(Date fireTime) {
        this.previousFireTime = fireTime;
    }

    public Date getFireTimeAfter(Date afterTime) {
        return this.getFireTimeAfter(afterTime, false);
    }

    public Date getFireTimeAfter(Date afterTime, boolean firstTime) {
        if (this.timesTriggered >= this.getRepeatCount() && this.getRepeatCount() != -1) {
            return null;
        }
        Date after = afterTime == null ? new Date() : (Date)afterTime.clone();
        if (this.getStartTime().after(after)) {
            after = new Date(this.getStartTime().getTime() - 1000L);
        }
        if (this.getEndTime() != null && after.compareTo(this.getEndTime()) >= 0) {
            return null;
        }
        Date pot = this.getTimeAfter(after, firstTime);
        if (this.getEndTime() != null && pot != null && pot.after(this.getEndTime())) {
            return null;
        }
        return pot;
    }

    public Date getFinalFireTime() {
        return this.getRecurrenceRule().getUntil();
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        if (misfireInstruction < -1) {
            return false;
        }
        return misfireInstruction <= 2;
    }

    public void updateAfterMisfire(Calendar cal) {
        int instr = this.getMisfireInstruction();
        if (instr == -1) {
            return;
        }
        if (instr == 0) {
            instr = 1;
        }
        if (instr == 2) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime())) {
                newFireTime = this.getFireTimeAfter(newFireTime);
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 1) {
            Date now = java.util.Calendar.getInstance().getTime();
            Date newNextFireTime = this.getFireTimeAfter(this.getNextFireTime(), false);
            while (newNextFireTime != null && (cal != null && !cal.isTimeIncluded(newNextFireTime.getTime()) || newNextFireTime.before(now))) {
                newNextFireTime = this.getFireTimeAfter(newNextFireTime, false);
            }
            this.setNextFireTime(newNextFireTime);
        }
    }

    public void triggered(Calendar calendar) {
        ++this.timesTriggered;
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public void updateWithNewCalendar(Calendar calendar, long misfireThreshold) {
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        if (this.nextFireTime == null || calendar == null) {
            return;
        }
        Date now = new Date();
        while (this.nextFireTime != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            long diff;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(this.nextFireTime);
            if (c.get(1) > YEAR_TO_GIVEUP_SCHEDULING_AT) {
                this.nextFireTime = null;
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(now) || (diff = now.getTime() - this.nextFireTime.getTime()) < misfireThreshold) continue;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public Date computeFirstFireTime(Calendar calendar) {
        Date now = java.util.Calendar.getInstance().getTime();
        this.nextFireTime = this.getFireTimeAfter(new Date(this.getStartTime().getTime() - 1000L), true);
        while (this.nextFireTime != null && (calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime()) || this.nextFireTime.before(now))) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime, false);
        }
        return this.nextFireTime;
    }

    public boolean hasAdditionalProperties() {
        return false;
    }

    public ScheduleBuilder<RecurrenceRuleTrigger> getScheduleBuilder() {
        RecurrenceRuleScheduleBuilder cb = RecurrenceRuleScheduleBuilder.recurrenceRuleSchedule(this.getRecurrenceRule());
        if (2 == this.getMisfireInstruction()) {
            cb.withMisfireHandlingInstructionDoNothing();
        } else if (1 == this.getMisfireInstruction()) {
            cb.withMisfireHandlingInstructionFireAndProceed();
        }
        return cb;
    }

    protected Date getTimeAfter(Date afterTime, boolean firstTime) {
        if (this.getRecurrenceRule() == null) {
            return null;
        }
        DateIterator it = this.getRecurrenceRule().getDateIterator(afterTime, TimeZone.getDefault());
        if (it.hasNext()) {
            Date nextDate = (Date)it.next();
            if (this.getRepeatCount() == 1) {
                return nextDate;
            }
            if (!firstTime) {
                nextDate = it.hasNext() ? (Date)it.next() : null;
            }
            return nextDate;
        }
        return null;
    }

    public int getTimesTriggered() {
        return this.timesTriggered;
    }

    public void setTimesTriggered(int timesTriggered) {
        this.timesTriggered = timesTriggered;
    }
}

