/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.schedule.dataobject.ScheduleTimeDO;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.entity.InternalTime;
import com.digiwin.app.schedule.entity.SingleTime;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.app.schedule.quartz.job.DWJobInvoker;
import com.digiwin.app.schedule.service.DWJobService;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import com.digiwin.app.schedule.util.DWScheduleTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class DWScheduleService {
    private static final String CLASS_TAG = "[DWSchedule.DWScheduleService]";
    private final Log log = LogFactory.getLog(this.getClass());
    private static DWScheduleService instance = null;
    private DWQuartz quartz = DWQuartz.getInstance();
    private DWJobService jobService = DWJobService.getInstance();

    public static DWScheduleService getInstance() {
        if (instance == null) {
            instance = new DWScheduleService();
        }
        return instance;
    }

    public boolean executeJob(DWScheduleQuartzInfo quartzInfo) throws Exception {
        try {
            JobDataMap jobDataMap = this.jobService.getJobDataMap(quartzInfo);
            jobDataMap.put("schedule_type", "0");
            String scheduleId = jobDataMap.getString("schedule_id");
            String jobName = jobDataMap.getString("job_name");
            JobDetail jobDetail = this.quartz.createJobDetail(jobName, scheduleId, jobDataMap, DWJobInvoker.class);
            this.quartz.addJob(jobDetail);
            this.quartz.triggerJob(jobDetail.getKey());
            return true;
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
            throw e;
        }
    }

    public boolean executeSchedule(String scheduleId, String jobName) {
        try {
            this.jobService.executeJob(jobName, scheduleId);
            return true;
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
            throw e;
        }
    }

    public boolean addSchedule(DWScheduleQuartzInfo quartzInfo) throws Exception {
        try {
            JobDataMap jobDataMap = this.jobService.getJobDataMap(quartzInfo);
            String jobName = quartzInfo.getJobName();
            JobDetail jobDetail = this.quartz.createJobDetail(jobName, quartzInfo.getScheduleId(), jobDataMap, DWJobInvoker.class);
            this.quartz.addJob(jobDetail);
            return true;
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
            throw e;
        }
    }

    public boolean addScheduleRunAtSpecificTime(DWScheduleQuartzInfo quartzInfo) throws Exception {
        try {
            JobDataMap jobDataMap = this.jobService.getJobDataMap(quartzInfo);
            Date specificDate = null;
            if (quartzInfo.getDetail().getAssignTime() != null && quartzInfo.getDetail().getAssignTime().length() > 0) {
                specificDate = DWScheduleTimeUtils.dateSDF.parse(quartzInfo.getDetail().getAssignTime());
            }
            String jobName = quartzInfo.getJobName();
            String scheduleId = quartzInfo.getScheduleId();
            JobDetail jobDetail = this.quartz.createJobDetail(jobName, scheduleId, jobDataMap, DWJobInvoker.class);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobName, scheduleId).startAt(specificDate).build();
            this.quartz.scheduleJob(trigger, jobDetail);
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
            throw e;
        }
        return true;
    }

    public boolean addSchedulePeriodically(DWScheduleQuartzInfo quartzInfo) throws Exception {
        try {
            JobDataMap jobDataMap = this.jobService.getJobDataMap(quartzInfo);
            List<String> expList = quartzInfo.getExpList();
            if (quartzInfo.getSingleTime() != null) {
                this.addScheduleJobBySingleTime(quartzInfo.getScheduleId(), jobDataMap, quartzInfo.getJobName(), quartzInfo.getSingleTime(), expList);
            } else if (quartzInfo.getInternalTimeList() != null) {
                this.addScheduleJobByInternalTime(quartzInfo.getScheduleId(), jobDataMap, quartzInfo.getInternalTimeList(), expList);
            }
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
            throw e;
        }
        return true;
    }

    private void addScheduleJobBySingleTime(String scheduleId, JobDataMap jobDataMap, String jobName, SingleTime singleTime, List<String> expList) throws Exception {
        String cronExp = singleTime.getSecond() + " " + singleTime.getMinute() + " " + singleTime.getHour() + " ";
        for (int i = 0; i < expList.size(); ++i) {
            try {
                JobDetail jobDetail = JobBuilder.newJob(DWJobInvoker.class).withIdentity(scheduleId + "(" + String.valueOf(i) + ")", scheduleId).setJobData(jobDataMap).build();
                Trigger trigger = DWQuartz.createTrigger(scheduleId + "(" + String.valueOf(i) + ")", scheduleId, cronExp + expList.get(i), 0);
                this.quartz.scheduleJob(trigger, jobDetail);
                continue;
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message != null && !message.startsWith("CronExpression") && message.endsWith("is invalid.")) {
                    throw e;
                }
                DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
            }
        }
    }

    private void addScheduleJobByInternalTime(String groupName, JobDataMap jobDataMap, List<InternalTime> internalTimeList, List<String> expList) throws Exception {
        for (int i = 0; i < internalTimeList.size(); ++i) {
            String second;
            String validateMessge;
            InternalTime internalTime = internalTimeList.get(i);
            int continueTime = Integer.parseInt(internalTime.getContinueTime());
            ArrayList<String> internalTimeCronExpList = new ArrayList<String>();
            String continueType = internalTime.getContinueType();
            int startSecond = Integer.valueOf(internalTime.getStartSecond());
            int startMinute = Integer.valueOf(internalTime.getStartMinute());
            int startHour = Integer.valueOf(internalTime.getStartHour());
            int endSecond = Integer.valueOf(internalTime.getEndSecond());
            int endMinute = Integer.valueOf(internalTime.getEndMinute());
            int endHour = Integer.valueOf(internalTime.getEndHour());
            if (startHour > endHour) {
                validateMessge = String.format("\u958b\u59cb\u6642\u9593\u665a\u65bc\u7d50\u675f\u6642\u9593, time%d=%d:%d:%d-%d:%d:%d", i + 1, startHour, startMinute, startSecond, endHour, endMinute, endSecond);
                throw new DWBusinessException(validateMessge);
            }
            if (startHour == endHour && startMinute > endMinute) {
                validateMessge = String.format("\u958b\u59cb\u6642\u9593\u665a\u65bc\u7d50\u675f\u6642\u9593, time%d=%d:%d:%d-%d:%d:%d", i + 1, startHour, startMinute, startSecond, endHour, endMinute, endSecond);
                throw new DWBusinessException(validateMessge);
            }
            if (continueType.equals("1")) {
                second = "0-0";
                int maxMinute = 59;
                int currentMinute = startMinute;
                for (int currentHour = startHour; currentHour <= endHour; ++currentHour) {
                    ArrayList<Integer> minutes = new ArrayList<Integer>();
                    int targetMinute = maxMinute;
                    if (currentHour == endHour) {
                        targetMinute = endMinute;
                    }
                    while (currentMinute <= targetMinute) {
                        minutes.add(new Integer(currentMinute));
                        currentMinute += continueTime;
                    }
                    if (minutes.size() == 0) {
                        minutes.add(targetMinute);
                    }
                    String cronExp = second + " " + StringUtils.join(minutes, (String)",") + " " + currentHour + " ";
                    internalTimeCronExpList.add(cronExp);
                    currentMinute %= maxMinute + 1;
                }
            } else if (continueType.equals("2")) {
                second = "0-0";
                String minute = startMinute + "-" + startMinute;
                String hour = startHour + "-" + endHour;
                String cronExp = second + " " + minute + " " + hour + "/" + continueTime + " ";
                internalTimeCronExpList.add(cronExp);
            }
            JobDetail jobDetail = this.quartz.createJobDetail("mix" + groupName + i, groupName, jobDataMap, DWJobInvoker.class);
            HashSet<Trigger> triggers = new HashSet<Trigger>();
            for (int j = 0; j < expList.size(); ++j) {
                for (int k = 0; k < internalTimeCronExpList.size(); ++k) {
                    this.log.debug((Object)("[dw quartz create trigger][before][" + i + "][" + j + "][" + k + "]" + new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss:SSS").format(new Date())));
                    Trigger trigger = DWQuartz.createTrigger("mix" + groupName + i + j + k, groupName, (String)internalTimeCronExpList.get(k) + expList.get(j), 0);
                    this.log.debug((Object)("[dw quartz create trigger][after][" + i + "][" + j + "][" + k + "]" + new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss:SSS").format(new Date())));
                    this.log.debug((Object)("CronExp(" + i + "," + j + "," + k + "):" + (String)internalTimeCronExpList.get(k) + expList.get(j)));
                    triggers.add(trigger);
                }
            }
            if (triggers.size() <= 0) continue;
            this.log.debug((Object)("[dw quartz schedule job][before][" + i + "]" + new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss:SSS").format(new Date())));
            this.quartz.scheduleJob(triggers, jobDetail);
            this.log.debug((Object)("[dw quartz schedule job][after][" + i + "]" + new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss:SSS").format(new Date())));
        }
    }

    public void addSimpleTriggerJob(String jobName, String triggerName, String groupName, Date startDate, Date endDate, String internalTime, JobDataMap jobDataMap, Class<? extends Job> jobClass) throws Exception {
        JobDetail jobDetail = this.quartz.createJobDetail(jobName, groupName, jobDataMap, jobClass);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName + startDate.toString(), groupName).startAt(startDate).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)Integer.parseInt(internalTime)).repeatForever()).endAt(endDate).build();
        this.quartz.scheduleJob(trigger, jobDetail);
    }

    public void removeSchedule(DWScheduleQuartzInfo quartzInfo) throws Exception {
        this.quartz.unScheduleJob(quartzInfo.getJobName(), quartzInfo.getScheduleId());
    }

    public boolean deleteJob(String scheduleId) {
        return this.quartz.deleteJob(scheduleId);
    }

    public void disableSchedule(String jobName, String scheduleId) throws Exception {
        this.quartz.unScheduleJob(jobName, scheduleId);
    }

    public void addScheduleJobByCalendarInterval(DWScheduleQuartzInfo quartzInfo) throws Exception {
        JobDataMap jobDataMap = this.jobService.getJobDataMap(quartzInfo);
        String groupName = quartzInfo.getScheduleId();
        String jobName = quartzInfo.getJobName();
        JobDetail jobDetail = this.quartz.createJobDetail(jobName, groupName, jobDataMap, DWJobInvoker.class);
        ScheduleTimeDO detail = quartzInfo.getDetail();
        Integer frequency = detail.getFrequency();
        DateBuilder.IntervalUnit unit = null;
        Integer repeatType = detail.getRepeatType();
        switch (repeatType) {
            case 1: {
                unit = DateBuilder.IntervalUnit.MINUTE;
                break;
            }
            case 2: {
                unit = DateBuilder.IntervalUnit.HOUR;
                break;
            }
            case 3: {
                unit = DateBuilder.IntervalUnit.DAY;
                break;
            }
        }
        Integer repeat = detail.getRepeatCount();
        Date startTime = detail.getStartTime();
        Date endTime = detail.getEndTime();
        Trigger trigger = repeat != null && repeat > 0 ? DWQuartz.createSimpleTrigger(groupName, groupName, frequency, unit, startTime, endTime, repeat) : DWQuartz.createCalendarTrigger(groupName, groupName, frequency, unit, startTime, endTime);
        this.quartz.scheduleJob(trigger, jobDetail);
    }

    public void addScheduleJobByRecurrenceRule(DWScheduleQuartzInfo quartzInfo) throws Exception {
        JobDataMap jobDataMap = this.jobService.getJobDataMap(quartzInfo);
        String groupName = quartzInfo.getScheduleId();
        String jobName = quartzInfo.getJobName();
        StringBuilder rruleSB = new StringBuilder("");
        ScheduleTimeDO detail = quartzInfo.getDetail();
        Integer minutely = detail.getMinutely();
        Integer hourly = detail.getHourly();
        Integer daily = detail.getDaily();
        Integer weekly = detail.getWeekly();
        String byDay = detail.getByDay();
        Integer monthly = detail.getMonthly();
        String byMonthday = detail.getByMonthday();
        String byWeeklyday = detail.getByWeeklyday();
        Integer repeatCount = detail.getRepeatCount();
        Date startTime = detail.getStartTime();
        Date endTime = detail.getEndTime();
        if (minutely >= 0) {
            rruleSB.append("FREQ=MINUTELY;INTERVAL=");
            rruleSB.append(minutely);
        } else if (hourly >= 0) {
            rruleSB.append("FREQ=HOURLY;INTERVAL=");
            rruleSB.append(hourly);
        } else if (daily >= 0) {
            rruleSB.append("FREQ=DAILY;INTERVAL=");
            rruleSB.append(daily);
        } else if (weekly >= 0) {
            rruleSB.append("FREQ=WEEKLY;INTERVAL=");
            rruleSB.append(weekly);
            rruleSB.append(";BYDAY=");
            rruleSB.append(byDay);
        } else if (byMonthday != null) {
            rruleSB.append("FREQ=MONTHLY;INTERVAL=");
            rruleSB.append(monthly.toString());
            rruleSB.append(";BYMONTHDAY=");
            rruleSB.append(byMonthday);
        } else if (byWeeklyday != null) {
            rruleSB.append("FREQ=MONTHLY;INTERVAL=");
            rruleSB.append(monthly.toString());
            rruleSB.append(";BYDAY=");
            rruleSB.append(byWeeklyday);
        }
        if (repeatCount != null && repeatCount > 0) {
            rruleSB.append(";COUNT=");
            rruleSB.append(repeatCount);
        }
        String rrule = quartzInfo.getRrule() == null ? rruleSB.toString() : quartzInfo.getRrule();
        JobDetail jobDetail = this.quartz.createJobDetail(jobName, groupName, jobDataMap, DWJobInvoker.class);
        Trigger trigger = DWQuartz.createRecurrenceRuleTrigger(groupName, groupName, rrule, startTime, endTime);
        this.quartz.scheduleJob(trigger, jobDetail);
    }
}

