/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.jdbcjobstore;

import com.digiwin.app.schedule.entity.DWTriggerKey;
import com.digiwin.app.schedule.entity.UpdateBatchPojo;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.app.schedule.quartz.delegate.DWStdJDBCDelegate;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;

public class DWJobStore
extends JobStoreTX {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void deleteBeforeStoreJobsAndTriggers(final List<UpdateBatchPojo> updateBatchPojos, final boolean replace) throws JobPersistenceException {
        this.executeInLock(this.isLockOnInsert() || replace ? "TRIGGER_ACCESS" : null, new VoidTransactionCallback(){

            @Override
            public void executeVoid(Connection conn) throws JobPersistenceException {
                for (UpdateBatchPojo updateBatchPojo : updateBatchPojos) {
                    Map<JobDetail, Set<? extends Trigger>> triggersAndJobs = updateBatchPojo.getTriggersAndJobs();
                    for (JobDetail jobDetail : triggersAndJobs.keySet()) {
                        Set jobKeys;
                        JobKey key = jobDetail.getKey();
                        int n = updateBatchPojo.getScheduleType();
                        if (1 == n) {
                            List triggers = DWJobStore.this.getTriggersForJob(conn, key);
                            if (triggers.size() <= 0) continue;
                            for (int i = 0; i < triggers.size(); ++i) {
                                DWJobStore.this.removeTrigger(conn, ((Trigger)triggers.get(i)).getKey());
                            }
                            continue;
                        }
                        String scheduleId = updateBatchPojo.getScheduleId();
                        GroupMatcher matcher = GroupMatcher.jobGroupEquals((String)scheduleId);
                        if (matcher == null) {
                            matcher = GroupMatcher.groupEquals((String)"DEFAULT");
                        }
                        if ((jobKeys = DWJobStore.this.getJobNames(conn, matcher)) == null || jobKeys.size() <= 0) continue;
                        for (JobKey jobKey : jobKeys) {
                            List triggers = DWJobStore.this.getTriggersForJob(conn, jobKey);
                            for (Trigger trigger : triggers) {
                                DWJobStore.this.removeTrigger(conn, trigger.getKey());
                            }
                            DWJobStore.this.removeJob(conn, jobKey);
                        }
                    }
                    for (Map.Entry entry : triggersAndJobs.entrySet()) {
                        Set set;
                        JobDetail job = (JobDetail)entry.getKey();
                        if (job == null || (set = (Set)entry.getValue()) == null) continue;
                        for (Trigger trigger : set) {
                            OperableTrigger opt = (OperableTrigger)trigger;
                            opt.setJobKey(job.getKey());
                            try {
                                opt.validate();
                            }
                            catch (SchedulerException schedulerException) {
                                throw new JobPersistenceException("", (Throwable)schedulerException);
                            }
                            Calendar cal = null;
                            if (trigger.getCalendarName() != null && (cal = DWJobStore.this.retrieveCalendar(conn, trigger.getCalendarName())) == null) {
                                throw new JobPersistenceException("Calendar '" + trigger.getCalendarName() + "' not found for trigger: " + trigger.getKey());
                            }
                            Date ft = opt.computeFirstFireTime(cal);
                            if (ft != null) continue;
                            throw new JobPersistenceException("Based on configured schedule, the given trigger will never fire.");
                        }
                    }
                    for (JobDetail jobDetail : triggersAndJobs.keySet()) {
                        DWJobStore.this.storeJob(conn, jobDetail, replace);
                        for (Trigger trigger : triggersAndJobs.get(jobDetail)) {
                            DWJobStore.this.storeTrigger(conn, (OperableTrigger)trigger, jobDetail, replace, "WAITING", false, false);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobStoreSupport.RecoverMisfiredJobsResult doRecoverMisfires() throws JobPersistenceException {
        boolean transOwner = false;
        Connection conn = this.getNonManagedTXConnection();
        boolean recovering = false;
        try {
            int maxMisfiresToHandleAtATime = recovering ? -1 : this.getMaxMisfiresToHandleAtATime();
            LinkedList<TriggerKey> misfiredTriggers = new LinkedList<TriggerKey>();
            long earliestNewTime = Long.MAX_VALUE;
            DWStdJDBCDelegate delegate = (DWStdJDBCDelegate)this.getDelegate();
            boolean hasMoreMisfiredTriggers = delegate.hasDWMisfiredTriggersInState(conn, "WAITING", this.getMisfireTime(), maxMisfiresToHandleAtATime, misfiredTriggers);
            if (hasMoreMisfiredTriggers) {
                this.getLog().info("Handling the first " + misfiredTriggers.size() + " triggers that missed their scheduled fire-time.  More misfired triggers remain to be processed.");
            } else if (misfiredTriggers.size() > 0) {
                this.getLog().info("Handling " + misfiredTriggers.size() + " trigger(s) that missed their scheduled fire-time.");
            } else {
                this.getLog().debug("Found 0 triggers that missed their scheduled fire-time.");
                JobStoreSupport.RecoverMisfiredJobsResult recoverMisfiredJobsResult = JobStoreSupport.RecoverMisfiredJobsResult.NO_OP;
                return recoverMisfiredJobsResult;
            }
            for (TriggerKey triggerKey : misfiredTriggers) {
                Map triggerRecords;
                OperableTrigger trig = this.retrieveTrigger(conn, triggerKey);
                if (trig == null) continue;
                String isMisfire = "true";
                trig.getJobDataMap().put("is_misfire", isMisfire);
                if (DistributedScheduleUtils.isWorker() && (triggerRecords = DWQuartz.redisTemplate.opsForHash().entries((Object)"DWQuartz::trigger::records")) != null) {
                    Map triggerRecord = (Map)triggerRecords.get(triggerKey.getGroup());
                    if (MapUtils.isNotEmpty((Map)triggerRecord) && trig.getNextFireTime().getTime() < (Long)triggerRecord.get("NEXT_FIRE_TIME") && DistributedScheduleUtils.isExecuteWorker((Trigger)trig)) {
                        Date redisNextTime = new Date((Long)triggerRecord.get("NEXT_FIRE_TIME"));
                        Date redisPrevTime = new Date((Long)triggerRecord.get("PREV_FIRE_TIME"));
                        Date now = new Date();
                        if (redisNextTime.after(now)) {
                            trig.getJobDataMap().put("is_misfire", "false");
                            trig.getJobDataMap().put("distributed_misfired", false);
                            trig.setNextFireTime(redisNextTime);
                            trig.setPreviousFireTime(redisPrevTime);
                        } else {
                            trig.getJobDataMap().put("distributed_misfired", true);
                        }
                        this.log.info((Object)String.format("========\u5206\u5e03\u5f0f\u6392\u7a0bmisfired\u66f4\u65b0trigger===scheduleId:%s nextFireTime:%s ", triggerKey.getGroup(), redisNextTime));
                    } else {
                        trig.getJobDataMap().put("distributed_misfired", true);
                        this.log.info((Object)String.format("========\u6b63\u5e38misfired===scheduleId:%s", triggerKey.getGroup()));
                    }
                }
                Field schedSignalerField = ((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getDeclaredField("schedSignaler");
                schedSignalerField.setAccessible(true);
                SchedulerSignaler schedSignaler = (SchedulerSignaler)schedSignalerField.get((Object)this);
                this.doUpdateOfMisfiredTrigger(schedSignaler, conn, trig, false, "WAITING", recovering);
                if (DistributedScheduleUtils.isWorker()) {
                    DistributedScheduleUtils.updateRedisRecord((Trigger)trig);
                }
                if (trig.getNextFireTime() == null || trig.getNextFireTime().getTime() >= earliestNewTime) continue;
                earliestNewTime = trig.getNextFireTime().getTime();
            }
            JobStoreSupport.RecoverMisfiredJobsResult result = new JobStoreSupport.RecoverMisfiredJobsResult(hasMoreMisfiredTriggers, misfiredTriggers.size(), earliestNewTime);
            this.commitConnection(conn);
            JobStoreSupport.RecoverMisfiredJobsResult recoverMisfiredJobsResult = result;
            return recoverMisfiredJobsResult;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (SQLException e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Database error recovering from misfires.", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Unexpected runtime exception: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Unexpected exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.releaseLock("TRIGGER_ACCESS", transOwner);
            }
            finally {
                this.cleanupConnection(conn);
            }
        }
    }

    private void doUpdateOfMisfiredTrigger(SchedulerSignaler schedSignaler, Connection conn, OperableTrigger trig, boolean forceState, String newStateIfNotComplete, boolean recovering) throws JobPersistenceException {
        Calendar cal = null;
        if (trig.getCalendarName() != null) {
            cal = this.retrieveCalendar(conn, trig.getCalendarName());
        }
        schedSignaler.notifyTriggerListenersMisfired((Trigger)trig);
        if (DistributedScheduleUtils.isWorker()) {
            boolean distributedMisfired = trig.getJobDataMap().getBooleanValue("distributed_misfired");
            if (distributedMisfired) {
                trig.updateAfterMisfire(cal);
            }
        } else {
            trig.updateAfterMisfire(cal);
        }
        if (trig.getNextFireTime() == null) {
            this.storeMisfiredTrigger(conn, trig, null, true, "COMPLETE", forceState, recovering);
            schedSignaler.notifySchedulerListenersFinalized((Trigger)trig);
        } else {
            this.storeMisfiredTrigger(conn, trig, null, true, newStateIfNotComplete, forceState, recovering);
        }
    }

    private void storeMisfiredTrigger(Connection conn, OperableTrigger newTrigger, JobDetail job, boolean replaceExisting, String state, boolean forceState, boolean recovering) throws JobPersistenceException {
        boolean existingTrigger = this.triggerExists(conn, newTrigger.getKey());
        if (existingTrigger && !replaceExisting) {
            throw new ObjectAlreadyExistsException((Trigger)newTrigger);
        }
        try {
            DWStdJDBCDelegate delegate = (DWStdJDBCDelegate)this.getDelegate();
            if (!forceState) {
                boolean shouldBepaused = delegate.isTriggerGroupPaused(conn, newTrigger.getKey().getGroup());
                if (!shouldBepaused && (shouldBepaused = delegate.isTriggerGroupPaused(conn, "_$_ALL_GROUPS_PAUSED_$_"))) {
                    delegate.insertPausedTriggerGroup(conn, newTrigger.getKey().getGroup());
                }
                if (shouldBepaused && (state.equals("WAITING") || state.equals("ACQUIRED"))) {
                    state = "PAUSED";
                }
            }
            if (job == null) {
                job = this.retrieveJob(conn, newTrigger.getJobKey());
            }
            if (job == null) {
                throw new JobPersistenceException("The job (" + newTrigger.getJobKey() + ") referenced by the trigger does not exist.");
            }
            if (job.isConcurrentExectionDisallowed() && !recovering) {
                state = this.checkBlockedState(conn, job.getKey(), state);
            }
            if (existingTrigger) {
                delegate.updateMisfiredTrigger(conn, newTrigger, state, job);
            } else {
                delegate.insertMisfiredTrigger(conn, newTrigger, state, job);
            }
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't store trigger '" + newTrigger.getKey() + "' for '" + newTrigger.getJobKey() + "' job:" + e.getMessage(), (Throwable)e);
        }
    }

    protected List<OperableTrigger> acquireNextTrigger(Connection conn, long noLaterThan, int maxCount, long timeWindow) throws JobPersistenceException {
        if (timeWindow < 0L) {
            throw new IllegalArgumentException();
        }
        ArrayList<OperableTrigger> acquiredTriggers = new ArrayList<OperableTrigger>();
        HashSet<JobKey> acquiredJobKeysForNoConcurrentExec = new HashSet<JobKey>();
        int MAX_DO_LOOP_RETRY = 3;
        int currentLoopCount = 0;
        if (DistributedScheduleUtils.isHigherMaster()) {
            return acquiredTriggers;
        }
        while (true) {
            ++currentLoopCount;
            try {
                DWStdJDBCDelegate delegate = (DWStdJDBCDelegate)this.getDelegate();
                List<DWTriggerKey> keys = delegate.selectDWTriggerToAcquire(conn, noLaterThan + timeWindow, this.getMisfireTime(), maxCount);
                if (keys == null || keys.size() == 0) {
                    return acquiredTriggers;
                }
                long batchEnd = noLaterThan;
                for (DWTriggerKey dwTriggerKey : keys) {
                    JobDetail job;
                    TriggerKey triggerKey = DWTriggerKey.convertToTriggerKey(dwTriggerKey);
                    String group = triggerKey.getGroup();
                    OperableTrigger nextTrigger = this.retrieveTrigger(conn, triggerKey);
                    if (nextTrigger == null) continue;
                    JobKey jobKey = nextTrigger.getJobKey();
                    try {
                        job = this.retrieveJob(conn, jobKey);
                    }
                    catch (JobPersistenceException jpe) {
                        try {
                            this.getLog().error("Error retrieving job, setting trigger state to ERROR.", (Throwable)jpe);
                            this.getDelegate().updateTriggerState(conn, triggerKey, "ERROR");
                        }
                        catch (SQLException sqle) {
                            this.getLog().error("Unable to set trigger state to ERROR.", (Throwable)sqle);
                        }
                        continue;
                    }
                    if (job.isConcurrentExectionDisallowed()) {
                        if (acquiredJobKeysForNoConcurrentExec.contains(jobKey)) continue;
                        acquiredJobKeysForNoConcurrentExec.add(jobKey);
                    }
                    if (nextTrigger.getNextFireTime().getTime() > batchEnd) break;
                    int rowsUpdated = this.getDelegate().updateTriggerStateFromOtherState(conn, triggerKey, "ACQUIRED", "WAITING");
                    if (rowsUpdated <= 0) continue;
                    nextTrigger.setFireInstanceId(this.getFiredTriggerRecordId());
                    this.getDelegate().insertFiredTrigger(conn, nextTrigger, "ACQUIRED", null);
                    if (acquiredTriggers.isEmpty()) {
                        batchEnd = Math.max(nextTrigger.getNextFireTime().getTime(), System.currentTimeMillis()) + timeWindow;
                    }
                    if (DistributedScheduleUtils.isWorker()) {
                        if (!DistributedScheduleUtils.isExecuteWorker((Trigger)nextTrigger)) continue;
                        acquiredTriggers.add(nextTrigger);
                        continue;
                    }
                    acquiredTriggers.add(nextTrigger);
                }
                if (acquiredTriggers.size() != 0 || currentLoopCount >= 3) break;
            }
            catch (Exception e) {
                throw new JobPersistenceException("Couldn't acquire next trigger: " + e.getMessage(), (Throwable)e);
            }
        }
        return acquiredTriggers;
    }

    protected abstract class VoidTransactionCallback
    implements JobStoreSupport.TransactionCallback<Void> {
        protected VoidTransactionCallback() {
        }

        public final Void execute(Connection conn) throws JobPersistenceException {
            this.executeVoid(conn);
            return null;
        }

        abstract void executeVoid(Connection var1) throws JobPersistenceException;
    }
}

