/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.util;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.util.HashMap;
import java.util.Map;
import org.quartz.JobDataMap;

public class DWScheduleServiceContextUtil {
    private static final boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    private static final String tenantColumnName = DWTenantUtils.getTenantColumnName();
    private static final String IAM_TENANTSID = DWTenantUtils.getIAMTenantSidKey();
    private static final String IAM_USERID = "userId";
    private static final String _SCHEDULEID = "schedule";

    public static Map<String, Object> initProfile(JobDataMap jobDataMap) {
        HashMap<String, Object> profile = new HashMap<String, Object>();
        if (tenantEnabled) {
            if (jobDataMap.containsKey((Object)tenantColumnName)) {
                profile.put(IAM_TENANTSID, jobDataMap.get((Object)tenantColumnName));
            }
            if (jobDataMap.containsKey((Object)"tenantId")) {
                String tenantId = String.valueOf(jobDataMap.get((Object)"tenantId"));
                profile.put("tenantId", tenantId);
            }
            if (jobDataMap.containsKey((Object)"dw_schedule_exec_userid") && jobDataMap.get((Object)"dw_schedule_exec_userid") != null) {
                profile.put(IAM_USERID, jobDataMap.get((Object)"dw_schedule_exec_userid"));
            } else {
                profile.put(IAM_USERID, _SCHEDULEID);
            }
        } else {
            profile.put(IAM_USERID, _SCHEDULEID);
        }
        DWServiceContext.getContext().setProfile(profile);
        return profile;
    }
}

