/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.entity.UpdateBatchPojo;
import com.digiwin.app.schedule.quartz.DWCalendarIntervalScheduleBuilder;
import com.digiwin.app.schedule.quartz.DWSimpleScheduleBuilder;
import com.digiwin.app.schedule.quartz.listener.DWQuartzJobListener;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.RecurrenceRuleScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.DWStdScheduler;
import org.quartz.impl.DWStdSchedulerFactory;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.data.redis.core.RedisTemplate;

public class DWQuartz {
    private static final String CLASS_TAG = "[DWSchedule.DWQuartz]";
    private final Log log = LogFactory.getLog(this.getClass());
    private static DWStdScheduler scheduler;
    private static DWQuartz instance;
    public static RedisTemplate redisTemplate;

    public static DWQuartz getInstance() {
        if (instance == null && SpringContextUtils.containsBean((String)"DWQuartz")) {
            instance = (DWQuartz)SpringContextUtils.getBean((String)"DWQuartz");
        }
        return instance;
    }

    public static void setInstance(DWQuartz instance) {
        DWQuartz.instance = instance;
    }

    public DWQuartz(Properties quartzProperties) throws Exception {
        DWQuartz.startup(quartzProperties);
    }

    public static void shutdown() throws Exception {
        if (scheduler != null) {
            scheduler.shutdown();
        }
    }

    public static void startup(Properties quartzProperties) throws Exception {
        DWStdSchedulerFactory factory = new DWStdSchedulerFactory(quartzProperties);
        scheduler = (DWStdScheduler)factory.getScheduler();
        scheduler.start();
        scheduler.getListenerManager().addJobListener((JobListener)new DWQuartzJobListener());
    }

    public void addJob(JobDetail jobDetail) throws Exception {
        scheduler.addJob(jobDetail, true, true);
    }

    public void triggerJob(JobKey jobkey) {
        try {
            scheduler.triggerJob(jobkey);
        }
        catch (SchedulerException e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, (Exception)((Object)e));
        }
    }

    public void scheduleJob(Trigger trigger, JobDetail jobDetail) throws Exception {
        try {
            scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            if (e.getMessage() != null && e.getMessage().endsWith("' will never fire.")) {
                this.log.warn((Object)("[DWSchedule.DWQuartz] " + e.getMessage()));
            }
            throw e;
        }
    }

    public void scheduleJob(Set<Trigger> triggers, JobDetail jobDetail) throws Exception {
        scheduler.scheduleJob(jobDetail, triggers, true);
    }

    public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs) throws Exception {
        scheduler.scheduleJobs(triggersAndJobs, true);
    }

    public void deleteBeforeStoreJobsAndTriggers(List<UpdateBatchPojo> updateBatchPojos) throws Exception {
        scheduler.deleteBeforeStoreJobsAndTriggers(updateBatchPojos, true);
    }

    public void unScheduleJob(String jobName, String groupName) throws Exception {
        JobKey key = new JobKey(jobName, groupName);
        List triggers = scheduler.getTriggersOfJob(key);
        if (triggers.size() > 0) {
            for (int i = 0; i < triggers.size(); ++i) {
                scheduler.unscheduleJob(((Trigger)triggers.get(i)).getKey());
            }
        }
    }

    public boolean deleteJob(String groupName) {
        boolean result = false;
        try {
            Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            if (jobKeys != null && jobKeys.size() > 0) {
                for (JobKey jobKey : jobKeys) {
                    if (scheduler.deleteJob(jobKey)) {
                        result = true;
                        continue;
                    }
                    result = false;
                }
            } else {
                result = true;
            }
        }
        catch (SchedulerException e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, (Exception)((Object)e));
        }
        return result;
    }

    public boolean deleteJob(JobKey jobKey) {
        try {
            return scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, (Exception)((Object)e));
            return false;
        }
    }

    public static Trigger createTrigger(String triggerName, String groupName, String cronExpression, int misfirePolicy, JobDataMap jobData) {
        Trigger trigger;
        switch (misfirePolicy) {
            case -1: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionIgnoreMisfires()).usingJobData(jobData).build();
                break;
            }
            case 2: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionDoNothing()).usingJobData(jobData).build();
                break;
            }
            case 1: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionFireAndProceed()).usingJobData(jobData).build();
                break;
            }
            case 0: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).usingJobData(jobData).build();
                break;
            }
            default: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).usingJobData(jobData).build();
            }
        }
        return trigger;
    }

    public JobDetail createJobDetail(String jobName, String groupName, JobDataMap jobDataMap, Class<? extends Job> jobClass) throws ClassNotFoundException {
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, groupName).setJobData(jobDataMap).build();
        return jobDetail;
    }

    public static Trigger createCalendarTrigger(String triggerName, String groupName, int timeInterval, DateBuilder.IntervalUnit unit, Date startTime, Date endTime, JobDataMap jobData) {
        Trigger trigger = null;
        DWCalendarIntervalScheduleBuilder cb = new DWCalendarIntervalScheduleBuilder();
        cb.withInterval(timeInterval, unit);
        trigger = endTime != null ? TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)cb).startAt(startTime).endAt(endTime).usingJobData(jobData).build() : TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)cb).startAt(startTime).usingJobData(jobData).build();
        return trigger;
    }

    public static Trigger createSimpleTrigger(String triggerName, String groupName, int timeInterval, DateBuilder.IntervalUnit unit, Date startTime, Date endTime, Integer repeat, JobDataMap jobData) {
        Trigger trigger = null;
        DWSimpleScheduleBuilder ssb = new DWSimpleScheduleBuilder();
        switch (unit) {
            case MINUTE: {
                ssb.withIntervalInMinutes(timeInterval);
                break;
            }
            case HOUR: {
                ssb.withIntervalInHours(timeInterval);
                break;
            }
            case DAY: {
                ssb.withIntervalInHours(24 * timeInterval);
                break;
            }
        }
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)ssb.withRepeatCount(repeat)).startAt(startTime).usingJobData(jobData);
        if (endTime != null) {
            builder.endAt(endTime);
        }
        trigger = builder.build();
        return trigger;
    }

    public static Trigger createRecurrenceRuleTrigger(String triggerName, String groupName, String rrule, Date startTime, Date endTime, JobDataMap jobData) {
        RecurrenceRuleScheduleBuilder builder = RecurrenceRuleScheduleBuilder.recurrenceRuleSchedule(rrule);
        return TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)builder).startAt(startTime).endAt(endTime).usingJobData(jobData).build();
    }

    public static String getSchedulerName() throws SchedulerException {
        return scheduler.getSchedulerName() == null ? "" : scheduler.getSchedulerName();
    }

    public boolean updateJobData(JobKey jobkey, Map<String, Object> newJobDataMap) throws Exception {
        JobDetailImpl jobDetail = (JobDetailImpl)scheduler.getJobDetail(jobkey);
        if (jobDetail != null) {
            jobDetail.setDurability(true);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            for (Map.Entry<String, Object> newJobData : newJobDataMap.entrySet()) {
                jobDataMap.put(newJobData.getKey().toString(), newJobData.getValue());
            }
            scheduler.addJob((JobDetail)jobDetail, true);
        }
        return true;
    }

    static {
        instance = null;
        redisTemplate = null;
    }
}

