/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.plugins.failurehandler;

import com.digiwin.app.sql.transaction.seata.plugins.DWSeataCache;
import com.digiwin.app.sql.transaction.seata.plugins.DWSeataPluginException;
import com.digiwin.app.sql.transaction.seata.plugins.failurehandler.UndoLogEntity;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.compressor.CompressorFactory;
import io.seata.core.compressor.CompressorType;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.GlobalTransaction;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWSeataFailureHandlerImpl
extends DefaultFailureHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWSeataFailureHandlerImpl.class);
    private static final String SELECT_UNDO_LOG_SQL = "SELECT * FROM %s WHERE xid = ?";
    private static final String DELETE_UNDO_LOG_SQL = "DELETE FROM %s WHERE xid = ?";
    private DataSource dataSource;
    private Boolean cleanEnabled;

    public DWSeataFailureHandlerImpl() {
    }

    public DWSeataFailureHandlerImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DWSeataFailureHandlerImpl(DataSource dataSource, boolean cleanEnabled) {
        if (cleanEnabled && Objects.isNull(dataSource)) {
            throw new DWSeataPluginException("DataSource is null.");
        }
        this.dataSource = dataSource;
        this.cleanEnabled = cleanEnabled;
    }

    public void onCommitFailure(GlobalTransaction tx, Throwable cause) {
        super.onCommitFailure(tx, cause);
        if (this.getCleanEnabled().booleanValue()) {
            this.cleanUndoLog(tx);
        }
    }

    public void onRollbackFailure(GlobalTransaction tx, Throwable originalException) {
        super.onRollbackFailure(tx, originalException);
        if (this.getCleanEnabled().booleanValue()) {
            this.cleanUndoLog(tx);
        }
    }

    public void onBeginFailure(GlobalTransaction tx, Throwable cause) {
        super.onBeginFailure(tx, cause);
    }

    public void onRollbacking(GlobalTransaction tx, Throwable originalException) {
        super.onRollbacking(tx, originalException);
    }

    private void cleanUndoLog(GlobalTransaction tx) {
        if (Objects.isNull(this.dataSource)) {
            throw new DWSeataPluginException("DataSource is null.");
        }
        String xid = tx.getXid();
        if (StringUtils.isBlank((String)xid)) {
            return;
        }
        String undoLogTable = ConfigurationFactory.getInstance().getConfig("client.undo.logTable", "undo_log");
        List<UndoLogEntity> undoLogList = this.checkAndGetUndoLog(undoLogTable, xid);
        if (CollectionUtils.isEmpty(undoLogList)) {
            return;
        }
        int rows = this.removeUndoLog(undoLogTable, xid);
        if (rows != undoLogList.size()) {
            LOGGER.warn("Delete rows[size={}] and query rows[size={}] not matched when xid={}", new Object[]{rows, undoLogList.size(), xid});
        } else {
            LOGGER.info("Delete undo log success, xid={}, size={}, rows={}", new Object[]{xid, rows, undoLogList});
        }
    }

    private List<UndoLogEntity> checkAndGetUndoLog(String undoLogTable, String xid) {
        String querySql = String.format(SELECT_UNDO_LOG_SQL, undoLogTable);
        Connection conn = null;
        PreparedStatement selectPst = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            selectPst = conn.prepareStatement(querySql);
            selectPst.setString(1, xid);
            rs = selectPst.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("Check undo log table error, table:{}, msg:{}", (Object)undoLogTable, (Object)e);
        }
        ArrayList<UndoLogEntity> undoLogList = new ArrayList<UndoLogEntity>();
        if (!Objects.isNull(rs)) {
            UndoLogEntity undoLogEntity = null;
            try {
                while (rs.next()) {
                    undoLogEntity = this.populateUndoLogEntity(rs, xid);
                    undoLogList.add(undoLogEntity);
                }
            }
            catch (Exception e) {
                LOGGER.error("Parse undo log rs error, table:{}, msg:{}", (Object)undoLogTable, (Object)e);
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (selectPst != null) {
                selectPst.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException closeEx) {
            LOGGER.error("Failed to close JDBC resource while check undo", (Throwable)closeEx);
        }
        return undoLogList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeUndoLog(String undoLogTable, String xid) {
        String deleteSql = String.format(DELETE_UNDO_LOG_SQL, undoLogTable);
        Connection conn = null;
        Statement pst = null;
        int rows = 0;
        try {
            conn = this.dataSource.getConnection();
            pst = conn.prepareStatement(deleteSql);
            pst.setString(1, xid);
            rows = pst.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Check undo log table error, table:{}, msg:{}", (Object)undoLogTable, (Object)e);
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException closeEx) {
                LOGGER.warn("Failed to close JDBC resource while delete undo", (Throwable)closeEx);
            }
        }
        return rows;
    }

    private UndoLogEntity populateUndoLogEntity(ResultSet rs, String xid) throws SQLException, UnsupportedEncodingException {
        UndoLogEntity undoLogEntity = new UndoLogEntity();
        undoLogEntity.setXid(xid);
        undoLogEntity.setBranchId(rs.getLong("branch_id"));
        undoLogEntity.setLogStatus(rs.getInt("log_status"));
        undoLogEntity.setLogCreated(rs.getTimestamp("log_created"));
        undoLogEntity.setLogModified(rs.getTimestamp("log_modified"));
        String contextStr = rs.getString("context");
        Map context = CollectionUtils.decodeMap((String)contextStr);
        undoLogEntity.setContext(contextStr);
        byte[] rollbackInfo = this.getRollbackInfo(rs);
        if (!Objects.isNull(rollbackInfo)) {
            undoLogEntity.setRollbackInfo(new String(rollbackInfo, StandardCharsets.UTF_8));
        }
        return undoLogEntity;
    }

    private byte[] getRollbackInfo(ResultSet rs) throws SQLException {
        byte[] rollbackInfo = rs.getBytes("rollback_info");
        String rollbackInfoContext = rs.getString("context");
        Map context = CollectionUtils.decodeMap((String)rollbackInfoContext);
        CompressorType compressorType = CompressorType.getByName((String)context.getOrDefault("compressorType", CompressorType.NONE.name()));
        return CompressorFactory.getCompressor((byte)compressorType.getCode()).decompress(rollbackInfo);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setCleanEnabled(boolean cleanEnabled) {
        this.cleanEnabled = cleanEnabled;
    }

    public Boolean getCleanEnabled() {
        if (!Objects.isNull(this.cleanEnabled)) {
            return this.cleanEnabled;
        }
        return DWSeataCache.isGlobalCleanEnabled();
    }
}

