/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.plugins.failurehandler;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import com.digiwin.http.client.utils.DWURIBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmHandler.class);
    private String sendUrl;
    private String appId;
    private String tenantId;
    private String iamUrl;
    private DWHttpClient dwHttpClient;

    public AlarmHandler(String sendUrl, String appId, String iamUrl, DWHttpClient dwHttpClient) {
        this(sendUrl, appId, iamUrl, dwHttpClient, null);
    }

    public AlarmHandler(String sendUrl, String appId, String iamUrl, DWHttpClient dwHttpClient, String tenantId) {
        this.sendUrl = sendUrl;
        this.appId = appId;
        this.tenantId = tenantId;
        this.iamUrl = iamUrl;
        this.dwHttpClient = dwHttpClient;
    }

    public boolean sendAlarm(String msgContent) {
        try {
            String token = this.doLogin();
            URI targetUri = DWURIBuilder.create((String)this.sendUrl).build();
            HttpPost post = new HttpPost(targetUri);
            post.addHeader("Content-Type", "application/json;charset=utf-8");
            post.addHeader("Client-Agent", "mobileplatform-2.0.1.1");
            post.addHeader("digi-middleware-auth-user", token);
            StringEntity entity = new StringEntity(this.populateParam(msgContent), StandardCharsets.UTF_8);
            post.setEntity((HttpEntity)entity);
            Map response = (Map)this.dwHttpClient.execute((HttpUriRequest)post, Map.class, DWRequestHeaderUtils::getDapApiRequiredHeaders);
            if (response.containsKey("status") && Double.parseDouble(response.get("status").toString()) == 200.0) {
                return true;
            }
            LOGGER.error("Post 'sendAlarm' response failed, result:{}", (Object)DWGsonProvider.getGson().toJson((Object)response));
        }
        catch (Exception e) {
            LOGGER.error("Execute 'sendAlarm' err:", (Throwable)e);
        }
        return false;
    }

    private String populateParam(String msgContent) {
        AlarmParam alarmParam = new AlarmParam();
        alarmParam.setAppId(this.appId);
        alarmParam.setAppCode(this.appId);
        alarmParam.setTenantId(this.tenantId);
        alarmParam.setErrorCode("P.SEATA.002.0001");
        alarmParam.setException(msgContent);
        return DWGsonProvider.getGson().toJson((Object)alarmParam);
    }

    private String doLogin() throws Exception {
        URI targetUri = DWURIBuilder.create((String)(this.iamUrl + "/api/iam/v2/identity/login/internal")).build();
        HttpPost post = new HttpPost(targetUri);
        post.addHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6ImRldiIsInNpZCI6MjIxNzA5OTU1MjY1MDg4fQ.QVRBduYyV3YVm3vlKHadN323ARJIPoiOw5RdMkUMYwg");
        post.addHeader("Content-Type", "application/json;charset=utf-8");
        post.addHeader("Client-Agent", "mobileplatform-2.0.1.1");
        HashMap<String, String> requestEntity = new HashMap<String, String>();
        requestEntity.put("tenantId", "99990000");
        requestEntity.put("userId", "integration");
        requestEntity.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        post.setEntity((HttpEntity)new DWJsonEntity(requestEntity));
        Map entity = (Map)this.dwHttpClient.execute((HttpUriRequest)post, Map.class);
        if (!entity.containsKey("token") || Objects.isNull(entity.get("token"))) {
            throw new RuntimeException("Response token is null");
        }
        String token = entity.get("token").toString();
        DWServiceContext.getContext().setToken(token);
        return token;
    }

    public static class AlarmParam {
        private String appCode;
        private String appId;
        private String isError = "1";
        private String errorCode;
        private String exception;
        private String tenantId;

        public String getAppCode() {
            return this.appCode;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getIsError() {
            return this.isError;
        }

        public void setIsError(String isError) {
            this.isError = isError;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getException() {
            return this.exception;
        }

        public void setException(String exception) {
            this.exception = exception;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String toString() {
            return "AlarmParam{appCode='" + this.appCode + "', appId='" + this.appId + "', isError='" + this.isError + "', errorCode='" + this.errorCode + "', exception='" + this.exception + "', tenantId='" + this.tenantId + "'}";
        }
    }
}

