/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.plugins.noticehandler;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.sql.transaction.seata.plugins.DWSeataPluginConstants;
import com.digiwin.app.sql.transaction.seata.plugins.DWSeataPluginException;
import com.digiwin.app.sql.transaction.seata.plugins.noticehandler.DWSeataGlobalTransactionHolder;
import com.digiwin.app.sql.transaction.seata.plugins.noticehandler.DWSeataHttpResponseEntity;
import com.digiwin.app.sql.transaction.seata.plugins.noticehandler.GlobalTransactionEntity;
import com.digiwin.app.sql.transaction.seata.plugins.noticehandler.NoticeParam;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

public class DWSeataNoticeHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWSeataNoticeHandler.class);
    private DataSource basicDataSource;
    private CloseableHttpClient httpClient;
    private String seataMonitorUrl;
    private String appId;

    public DWSeataNoticeHandler(CloseableHttpClient httpClient, DataSource dataSource, String seataMonitorUrl, String appId) {
        this.appId = appId;
        this.httpClient = httpClient;
        this.basicDataSource = dataSource;
        this.seataMonitorUrl = seataMonitorUrl;
    }

    public void destroy() throws Exception {
        LOGGER.info("[Destroy] destroy seata notice handler beginning.");
        List<GlobalTransactionEntity> globalTransactionList = DWSeataGlobalTransactionHolder.getInstance().getAll();
        if (!CollectionUtils.isEmpty(globalTransactionList)) {
            this.batchInsert(globalTransactionList);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Destroy] step 1: batch save global transactions");
            }
            List<String> xidList = globalTransactionList.stream().map(GlobalTransactionEntity::getXid).toList();
            this.notifySeataMonitor(xidList);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Destroy] step 2: notify seata monitor");
            }
            this.batchUpdate(xidList, DWSeataPluginConstants.NOTICE_STATUS_YES);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Destroy] step 3: batch update global transactions status");
            }
        }
        if (!Objects.isNull(this.httpClient)) {
            this.httpClient.close();
        }
        LOGGER.info("[Destroy] destroy seata notice handler finished.");
    }

    public void afterPropertiesSet() throws Exception {
        new Thread(() -> {
            LOGGER.info("[Initializing] notify seata notice beginning.");
            try {
                this.batchDelete();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("[Initializing] step 0: remove expiration global transactions");
                }
            }
            catch (Exception e) {
                LOGGER.error("Clean up the data that has been notified error:", (Throwable)e);
            }
            List<GlobalTransactionEntity> records = this.queryUnNotifiedList();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Initializing] step 1: query global transactions from db");
            }
            if (CollectionUtils.isEmpty(records)) {
                LOGGER.info("[Initializing] not notified any global transactions");
                return;
            }
            List<String> xidList = records.stream().map(GlobalTransactionEntity::getXid).toList();
            for (int retry = 0; retry <= DWSeataPluginConstants.NOTICE_RETRY_TIMES; ++retry) {
                try {
                    this.notifySeataMonitor(xidList);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("[Initializing] step 2: notify seata monitor");
                    }
                    this.batchUpdate(xidList, DWSeataPluginConstants.NOTICE_STATUS_YES);
                    if (!LOGGER.isInfoEnabled()) break;
                    LOGGER.info("[Initializing] step 3: batch update global transactions status");
                    break;
                }
                catch (Exception e) {
                    if (retry == DWSeataPluginConstants.NOTICE_RETRY_TIMES) {
                        LOGGER.error("[Initializing] push global transactions failed with retry [{}] times", (Object)retry, (Object)e);
                    }
                    try {
                        Thread.sleep(DWSeataPluginConstants.NOTICE_RETRY_INTERVAL.intValue());
                    }
                    catch (InterruptedException e2) {
                        LOGGER.error("Thread interrupted:", (Throwable)e2);
                    }
                    continue;
                }
            }
            LOGGER.info("[Initializing] notify seata notice finished.");
        }).start();
    }

    private void notifySeataMonitor(List<String> xidList) {
        String responseBody = "";
        try {
            HttpPost post = new HttpPost(this.seataMonitorUrl + "/restful/standard/default/api/cleanSeataTx");
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Client-Agent", "mobileplatform-2.0.1.1");
            post.addHeader("digi-middleware-auth-user", "");
            post.setEntity((HttpEntity)new StringEntity(DWGsonProvider.getGson().toJson((Object)new NoticeParam(xidList, this.appId))));
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            throw new DWSeataPluginException("Post seata monitor error: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        DWSeataHttpResponseEntity result = (DWSeataHttpResponseEntity)((Object)DWGsonProvider.getGson().fromJson(responseBody, DWSeataHttpResponseEntity.class));
        if (Objects.isNull(result.getResponse()) || !result.getResponse().getSuccess().booleanValue()) {
            throw new DWSeataPluginException("Call seata monitor response failed, response body: " + responseBody);
        }
    }

    private List<GlobalTransactionEntity> queryUnNotifiedList() {
        ArrayList<GlobalTransactionEntity> resultList = new ArrayList<GlobalTransactionEntity>();
        Connection conn = null;
        PreparedStatement selectPst = null;
        ResultSet rs = null;
        try {
            conn = this.basicDataSource.getConnection();
            selectPst = conn.prepareStatement("SELECT `app_id`, `xid`, `branch_type`, `begin_time`, `notice_status`, `retry_times`, `gmt_created`, `gmt_modified` FROM `dw_seata_notice` WHERE `notice_status` = ? AND `app_id` = ?");
            selectPst.setInt(1, DWSeataPluginConstants.NOTICE_STATUS_NO);
            selectPst.setString(2, this.appId);
            rs = selectPst.executeQuery();
            if (!Objects.isNull(rs)) {
                while (rs.next()) {
                    GlobalTransactionEntity entity = this.populateEntity(rs);
                    resultList.add(entity);
                }
            }
        }
        catch (SQLException e) {
            throw new DWSeataPluginException("Execute 'queryUnNotifiedList' error:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (selectPst != null) {
                    selectPst.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException closeEx) {
                LOGGER.error("Failed to close JDBC resource while 'queryUnNotifiedList'", (Throwable)closeEx);
            }
        }
        return resultList;
    }

    private void batchInsert(List<GlobalTransactionEntity> records) {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.basicDataSource.getConnection();
            pstmt = conn.prepareStatement("INSERT INTO `dw_seata_notice`(`app_id`, `xid`, `branch_type`, `begin_time`, `notice_status`, `retry_times`, `gmt_created`, `gmt_modified`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            conn.setAutoCommit(false);
            for (GlobalTransactionEntity record : records) {
                Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis());
                pstmt.setString(1, this.appId);
                pstmt.setString(2, record.getXid());
                pstmt.setString(3, record.getBranchType());
                pstmt.setTimestamp(4, record.getBeginTime());
                pstmt.setInt(5, Objects.isNull(record.getNoticeStatus()) ? 0 : record.getNoticeStatus());
                pstmt.setInt(6, Objects.isNull(record.getRetryTimes()) ? 0 : record.getRetryTimes());
                pstmt.setTimestamp(7, currentTimestamp);
                pstmt.setTimestamp(8, currentTimestamp);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                LOGGER.error("Rollback 'batchInsert' error", (Throwable)ex);
            }
            throw new DWSeataPluginException("Execute 'batchInsert' error: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("Failed to close JDBC resource while 'batchInsert'", (Throwable)e);
            }
        }
    }

    private void batchUpdate(List<String> xidList, Integer status) {
        Connection conn = null;
        Statement pstmt = null;
        int index = 1;
        try {
            Object[] valueArray = Collections.nCopies(xidList.size(), "?").toArray(new String[xidList.size()]);
            String execSql = String.format("UPDATE `dw_seata_notice` SET `retry_times` = `retry_times` + 1, `notice_status` = ?, `gmt_modified` = ? WHERE `app_id` = ? AND `xid` IN (%s)", StringUtils.join((Object[])valueArray, (String)", "));
            conn = this.basicDataSource.getConnection();
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(execSql);
            pstmt.setInt(index++, status);
            pstmt.setTimestamp(index++, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(index++, this.appId);
            for (String xid : xidList) {
                pstmt.setString(index, xid);
                ++index;
            }
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new DWSeataPluginException("Execute 'batchUpdate' error:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("Failed to close JDBC resource while 'batchUpdate'", (Throwable)e);
            }
        }
    }

    private void batchDelete() {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.basicDataSource.getConnection();
            pstmt = conn.prepareStatement("DELETE FROM `dw_seata_notice` WHERE `notice_status` = ? AND `app_id` = ?");
            pstmt.setInt(1, DWSeataPluginConstants.NOTICE_STATUS_YES);
            pstmt.setString(2, this.appId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new DWSeataPluginException("Execute 'batchDelete' error:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("Failed to close JDBC resource while 'batchDelete'", (Throwable)e);
            }
        }
    }

    private GlobalTransactionEntity populateEntity(ResultSet rs) throws SQLException {
        GlobalTransactionEntity entity = new GlobalTransactionEntity();
        entity.setAppId(rs.getString("app_id"));
        entity.setXid(rs.getString("xid"));
        entity.setBeginTime(rs.getTimestamp("begin_time"));
        entity.setBranchType(rs.getString("branch_type"));
        entity.setNoticeStatus(rs.getInt("notice_status"));
        entity.setRetryTimes(rs.getInt("retry_times"));
        entity.setGmtCreated(rs.getTimestamp("gmt_created"));
        entity.setGmtModified(rs.getTimestamp("gmt_modified"));
        return entity;
    }
}

