/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata;

import com.digiwin.app.common.DWApplicationConfigUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class DWSeataPropertyConfiguration {
    private static final String SEATA_PREFIX = "seata.";
    private static final String SEATA_SERVICE_PREFIX = "seata.service.";
    private static final String SEATA_CLIENT_PREFIX = "seata.client.";
    private static final String SEATA_CONFIG_PREFIX = "seata.config.";
    private static final String SEATA_REGISTRY_PREFIX = "seata.registry.";
    private static final String SEATA_applicationId = "seata.application-id";
    private static final String SEATA_txServiceGroup = "seata.tx-service-group";
    private static String vgroupMapping;
    private String applicationId;
    private String txServiceGroup;
    private boolean enableAutoDataSourceProxy = true;
    private String dataSourceProxyMode = "AT";
    private boolean useJdkProxy = false;
    private String[] excludesForAutoProxying = new String[0];

    public DWSeataPropertyConfiguration() {
    }

    public DWSeataPropertyConfiguration(Map<String, Object> extendConfig) {
        if (extendConfig != null && extendConfig.size() > 0) {
            extendConfig.entrySet().stream().filter(Objects::nonNull).forEach(x -> System.setProperty((String)x.getKey(), (String)x.getValue()));
        }
    }

    public String getApplicationId() {
        if (this.applicationId == null) {
            this.applicationId = System.getProperty(SEATA_applicationId);
        }
        return this.applicationId;
    }

    public DWSeataPropertyConfiguration setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public String getTxServiceGroup() {
        if (this.txServiceGroup == null) {
            this.txServiceGroup = System.getProperty(SEATA_txServiceGroup);
        }
        return this.txServiceGroup;
    }

    public DWSeataPropertyConfiguration setTxServiceGroup(String txServiceGroup) {
        this.txServiceGroup = txServiceGroup;
        return this;
    }

    public boolean isEnableAutoDataSourceProxy() {
        return this.enableAutoDataSourceProxy;
    }

    public void setEnableAutoDataSourceProxy(boolean enableAutoDataSourceProxy) {
        this.enableAutoDataSourceProxy = enableAutoDataSourceProxy;
    }

    public String getDataSourceProxyMode() {
        return this.dataSourceProxyMode;
    }

    public void setDataSourceProxyMode(String dataSourceProxyMode) {
        this.dataSourceProxyMode = dataSourceProxyMode;
    }

    public boolean isUseJdkProxy() {
        return this.useJdkProxy;
    }

    public void setUseJdkProxy(boolean useJdkProxy) {
        this.useJdkProxy = useJdkProxy;
    }

    public String[] getExcludesForAutoProxying() {
        return this.excludesForAutoProxying;
    }

    public void setExcludesForAutoProxying(String[] excludesForAutoProxying) {
        this.excludesForAutoProxying = excludesForAutoProxying;
    }

    static {
        Properties applicationProperties = DWApplicationConfigUtils.getProperties();
        if (applicationProperties != null) {
            for (String key : applicationProperties.stringPropertyNames()) {
                if (!key.startsWith(SEATA_PREFIX)) continue;
                if (key.startsWith(SEATA_CLIENT_PREFIX) || key.startsWith(SEATA_REGISTRY_PREFIX) || key.startsWith(SEATA_CONFIG_PREFIX) || key.startsWith(SEATA_SERVICE_PREFIX)) {
                    System.setProperty(key.substring(SEATA_PREFIX.length()), applicationProperties.getProperty(key));
                }
                System.setProperty(key, applicationProperties.getProperty(key));
            }
        }
    }
}

