/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.config;

import com.digiwin.app.sql.transaction.seata.DWSeataPropertyConfiguration;
import com.digiwin.app.sql.transaction.seata.aop.DWSeataCustomizeHttpRequestInterceptor;
import com.digiwin.app.sql.transaction.seata.filter.DWSeataContextFilter;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.annotation.datasource.EnableAutoDataSourceProxy;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import javax.servlet.Filter;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@EnableAutoDataSourceProxy(excludes={"org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy", "com.zaxxer.hikari.HikariDataSource"})
@ConditionalOnProperty(prefix="seata.", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class DWDtxAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(DWDtxAutoConfiguration.class);
    private static final String BEAN_DW_SEATAPROPERTY_CONFIGURATION = "dw-seata-property-configuration";
    private static final String BEAN_DW_GLOBALTRANSACTIONSCANNER = "dw-seata-globalTransactionScanner";
    private static final int ALLOW_ANONYMOUS_FILTER_ORDER = 100000;
    public static final int SEATA_CONTEXT_FILTER_ORDER = 100001;

    @Bean(value={"dw-seata-property-configuration"})
    @DependsOn(value={"dw-datasource-properties"})
    @ConditionalOnMissingBean(value={DWSeataPropertyConfiguration.class})
    public DWSeataPropertyConfiguration dwSeataPropertyConfiguration() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"[DWDtxAutoConfiguration] Seata: Automatically configure properties");
        }
        return new DWSeataPropertyConfiguration();
    }

    @Bean(value={"failureHandler"})
    @ConditionalOnMissingBean(value={FailureHandler.class})
    public FailureHandler failureHandler() {
        return new DefaultFailureHandlerImpl();
    }

    @Bean(value={"dw-seata-globalTransactionScanner"})
    @DependsOn(value={"dw-seata-property-configuration", "failureHandler"})
    @ConditionalOnMissingBean(value={GlobalTransactionScanner.class})
    public GlobalTransactionScanner globalTransactionScanner(DWSeataPropertyConfiguration seataProperties, FailureHandler failureHandler) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"[DWDtxAutoConfiguration] Seata: Automatically configure bean GlobalTransactionScanner");
        }
        return new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), failureHandler);
    }

    @Bean(value={"dw-seata-context-filter"})
    public DWSeataContextFilter seataContextFilter() {
        return new DWSeataContextFilter();
    }

    @Bean(value={"dw-seata-context-filter-reg"})
    public FilterRegistrationBean<DWSeataContextFilter> seataContextFilterRegBean(@Qualifier(value="dw-seata-context-filter") DWSeataContextFilter seataContextFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)seataContextFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(100001);
        return registration;
    }

    @Bean(value={"dw-seata-consumer-http-aop"})
    public DefaultPointcutAdvisor dwSeataConsumerHttpRequestAop() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("within(org.apache.http.client.HttpClient+) && execution(public org.apache.http.HttpResponse execute(org.apache.http.client.methods.HttpUriRequest))");
        DWSeataCustomizeHttpRequestInterceptor interceptor = new DWSeataCustomizeHttpRequestInterceptor();
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }
}

