/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.filter;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.sql.transaction.seata.DWSeataConstants;
import com.digiwin.app.sql.transaction.seata.utils.DWSeataCustomRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWSeataContextFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWSeataContextFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[DWSeataContextFilter] init");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[DWSeataContextFilter] doFilter");
        }
        String rpcSeataTxXid = httpRequest.getHeader("TX_XID");
        String rpcDapTxXid = httpRequest.getHeader(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[DWSeataContextFilter] {} ({}), digiwin {} ({})", new Object[]{"TX_XID", rpcSeataTxXid, DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, rpcDapTxXid});
        }
        if (rpcSeataTxXid == null && rpcDapTxXid != null) {
            LOGGER.debug("[DWSeataContextFilter] recover {} ({})", (Object)"TX_XID", (Object)rpcDapTxXid);
            DWSeataCustomRequestWrapper requestWrapper = new DWSeataCustomRequestWrapper(httpRequest);
            requestWrapper.addHeader("TX_XID", rpcDapTxXid);
            DWServiceContext.getContext().getRequestHeader().put(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, rpcDapTxXid);
            DWServiceContext.getContext().set(DWSeataConstants.KEY_HEADER_DIGIWIN_GTXID, (Object)rpcDapTxXid);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[DWSeataContextFilter] add request header({}, {})", (Object)"TX_XID", (Object)rpcDapTxXid);
            }
            request = requestWrapper;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

