/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.saga.processor;

import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaCallback;
import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaException;
import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaParam;
import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaProcessCtrlStateMachineEngine;
import com.digiwin.app.sql.transaction.seata.saga.DWSeataSagaResponse;
import com.digiwin.app.sql.transaction.seata.saga.annotation.DWSeataSagaHandler;
import io.seata.saga.statelang.domain.StateMachineInstance;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class DWSeataSagaHandlerProxy
implements MethodInterceptor {
    private Class<?> targetClazz;
    private ApplicationContext applicationContext;

    public DWSeataSagaHandlerProxy(Class<?> targetClazz, ApplicationContext applicationContext) {
        this.targetClazz = targetClazz;
        this.applicationContext = applicationContext;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        DWSeataSagaHandler handler = (DWSeataSagaHandler)AnnotationUtils.getAnnotation((Method)method, DWSeataSagaHandler.class);
        if (handler != null) {
            StateMachineInstance stateMachineInstance;
            String stateMachineName = handler.stateMachineName();
            DWSeataSagaParam sagaParam = null;
            if (!StringUtils.hasText((String)stateMachineName)) {
                throw new DWSeataSagaException("'stateMachineName' is empty when invoking '" + obj.getClass().getName() + "." + method.getName() + "()'");
            }
            for (Object arg : args) {
                if (!(arg instanceof DWSeataSagaParam)) continue;
                sagaParam = (DWSeataSagaParam)arg;
                break;
            }
            if (!Objects.isNull(sagaParam) && !StringUtils.hasText((String)sagaParam.getBusinessKey())) {
                sagaParam.setBusinessKey(this.generateUniqueId());
            }
            if (!Objects.isNull(stateMachineInstance = this.startEngine(stateMachineName, sagaParam, handler.enableAsync()))) {
                DWSeataSagaCallback callback = null;
                if (!Objects.isNull(sagaParam) && !Objects.isNull(callback = sagaParam.getCallback())) {
                    callback.onFinished(null, stateMachineInstance);
                }
            }
            return null;
        }
        return methodProxy.invokeSuper(obj, args);
    }

    private StateMachineInstance startEngine(String stateMachineName, DWSeataSagaParam sagaParam, boolean enableAsync) {
        DWSeataSagaProcessCtrlStateMachineEngine stateMachineEngine = (DWSeataSagaProcessCtrlStateMachineEngine)((Object)this.applicationContext.getBean(DWSeataSagaProcessCtrlStateMachineEngine.class));
        StateMachineInstance stateMachineInstance = null;
        if (Objects.isNull(sagaParam)) {
            stateMachineInstance = stateMachineEngine.start(stateMachineName, null, null);
        } else {
            String businessKey = sagaParam.getBusinessKey();
            Map<String, Object> params = sagaParam.getParams();
            params.put("businessKey", businessKey);
            if (enableAsync) {
                stateMachineEngine.startWithBusinessKeyAsync(stateMachineName, null, businessKey, params, sagaParam.getCallback());
            } else {
                stateMachineInstance = stateMachineEngine.startWithBusinessKey(stateMachineName, null, businessKey, params);
            }
        }
        return stateMachineInstance;
    }

    private boolean matchResponseClazz(Class<?> clazz) {
        if (Void.TYPE.equals(clazz)) {
            return false;
        }
        return clazz.equals(DWSeataSagaResponse.class) || clazz.isAssignableFrom(DWSeataSagaResponse.class);
    }

    private String generateUniqueId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DWSeataSagaHandlerProxy that = (DWSeataSagaHandlerProxy)o;
        return Objects.equals(this.targetClazz, that.targetClazz);
    }

    public int hashCode() {
        return Objects.hashCode(this.targetClazz);
    }
}

