/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql.transaction.seata.config;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.dao.properties.DWDaoDataSourceProperties;
import com.digiwin.app.dao.security.AESUtil;
import com.digiwin.app.sql.transaction.seata.DWSeataPropertyConfiguration;
import com.digiwin.app.sql.transaction.seata.aop.DWSeataCustomizeHttpRequestInterceptor;
import com.digiwin.app.sql.transaction.seata.filter.DWSeataContextFilter;
import com.digiwin.app.sql.transaction.seata.plugins.DWSeataCache;
import com.digiwin.app.sql.transaction.seata.plugins.failurehandler.DWSeataFailureHandlerImpl;
import com.digiwin.app.sql.transaction.seata.plugins.noticehandler.DWSeataNoticeHandler;
import com.digiwin.app.sql.transaction.seata.plugins.noticehandler.DWSeataNoticeScheduler;
import com.digiwin.http.client.DWHttpClientProperties;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.annotation.datasource.SeataAutoDataSourceProxyCreator;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.Filter;
import java.util.Objects;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.apache.commons.dbcp2.DWBasicDataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(prefix="seata.", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class DWDtxAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(DWDtxAutoConfiguration.class);
    private static final String BEAN_DW_SEATAPROPERTY_CONFIGURATION = "dw-seata-property-configuration";
    private static final String BEAN_DW_GLOBALTRANSACTIONSCANNER = "dw-seata-globalTransactionScanner";
    private static final String BEAN_NAME_SEATA_AUTO_DATA_SOURCE_PROXY_CREATOR = "seataAutoDataSourceProxyCreator";
    public static final String BEAN_DW_HTTP_PROPERTIES = "dw-http-client-properties";
    public static final String BEAN_DW_HTTP_CLIENT = "dw-httpclient";
    public static final String BEAN_DW_BASIC_DATASOURCE = "dw-basicDataSource";
    public static final String BEAN_DW_DATASOURCE_PROPERTIES = "dw-datasource-properties";
    public static final String BEAN_DW_SEATA_NOTICE_HANDLER = "dw-seata-noticeHandler";
    private static final int ALLOW_ANONYMOUS_FILTER_ORDER = 100000;
    public static final int SEATA_CONTEXT_FILTER_ORDER = 100001;

    @Bean(value={"dw-seata-property-configuration"})
    @DependsOn(value={"dw-datasource-properties"})
    @ConditionalOnMissingBean(value={DWSeataPropertyConfiguration.class})
    public DWSeataPropertyConfiguration dwSeataPropertyConfiguration() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"[DWDtxAutoConfiguration] Seata: Automatically configure properties");
        }
        return new DWSeataPropertyConfiguration();
    }

    @Bean(name={"dw-basicDataSource"})
    @DependsOn(value={"dw-datasource-properties"})
    @ConditionalOnProperty(name={"seata.cleanUndoLog.enabled"}, havingValue="true", matchIfMissing=false)
    public DataSource dwBasicDataSource(@Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties) {
        return this.creataDwBasicDataSource(dataSourceProperties);
    }

    @Bean(value={"failureHandler"})
    @ConditionalOnMissingBean(value={FailureHandler.class})
    public FailureHandler failureHandler(@Qualifier(value="dw-basicDataSource") @Autowired(required=false) DataSource basicDataSource, @Qualifier(value="seataUndoLogDataSource") @Autowired(required=false) DataSource seataUndoLogDataSource) {
        boolean cleanEnabled = Boolean.parseBoolean(DWApplicationConfigUtils.getProperty((String)"seata.cleanUndoLog.enabled", (String)"false"));
        DWSeataCache.setGlobalCleanEnabled((boolean)cleanEnabled);
        if (StringUtils.hasText((String)DWApplicationConfigUtils.getProperty((String)"appId"))) {
            DWSeataCache.putGlobalConfig((String)"appId", (Object)DWApplicationConfigUtils.getProperty((String)"appId"));
        }
        if (StringUtils.hasText((String)DWApplicationConfigUtils.getProperty((String)"alarmUrl"))) {
            DWSeataCache.putGlobalConfig((String)"alarmUrl", (Object)DWApplicationConfigUtils.getProperty((String)"alarmUrl"));
        }
        if (StringUtils.hasText((String)DWApplicationConfigUtils.getProperty((String)"iamUrl"))) {
            DWSeataCache.putGlobalConfig((String)"iamUrl", (Object)DWApplicationConfigUtils.getProperty((String)"iamUrl"));
        }
        DataSource globalDataSource = basicDataSource;
        if (!Objects.isNull(seataUndoLogDataSource)) {
            globalDataSource = seataUndoLogDataSource;
        }
        if (!Objects.isNull(globalDataSource)) {
            DWSeataCache.putGlobalDataSource((String)"seataUndoLogDataSource", (DataSource)globalDataSource);
        }
        if (cleanEnabled) {
            return new DWSeataFailureHandlerImpl();
        }
        return new DefaultFailureHandlerImpl();
    }

    @Bean(value={"dw-seata-globalTransactionScanner"})
    @DependsOn(value={"dw-seata-property-configuration", "failureHandler"})
    @ConditionalOnMissingBean(value={GlobalTransactionScanner.class})
    public GlobalTransactionScanner globalTransactionScanner(DWSeataPropertyConfiguration seataProperties, FailureHandler failureHandler) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"[DWDtxAutoConfiguration] Seata: Automatically configure bean GlobalTransactionScanner");
        }
        return new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), failureHandler);
    }

    @Bean(value={"seataAutoDataSourceProxyCreator"})
    @DependsOn(value={"dw-seata-property-configuration"})
    @ConditionalOnMissingBean(value={SeataAutoDataSourceProxyCreator.class})
    @ConditionalOnExpression(value="!${seata.dynamicDatasource.enabled:false}")
    public SeataAutoDataSourceProxyCreator seataAutoDataSourceProxyCreator(DWSeataPropertyConfiguration seataProperties) {
        String[] excludesDsNames = new String[]{"org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy", "com.zaxxer.hikari.HikariDataSource"};
        if (!ArrayUtils.isEmpty((Object[])seataProperties.getExcludesForAutoProxying())) {
            excludesDsNames = seataProperties.getExcludesForAutoProxying();
        }
        return new SeataAutoDataSourceProxyCreator(seataProperties.isUseJdkProxy(), excludesDsNames, seataProperties.getDataSourceProxyMode());
    }

    @Bean(value={"dw-seata-noticeHandler"})
    @DependsOn(value={"dw-datasource-properties", "dw-http-client-properties"})
    @ConditionalOnMissingBean(value={DWSeataNoticeHandler.class})
    @ConditionalOnProperty(name={"seata.cleanUndoLog.enabled"}, havingValue="true", matchIfMissing=false)
    public DWSeataNoticeHandler newDWSeataNoticeHandler(@Qualifier(value="dw-datasource-properties") DWDaoDataSourceProperties dataSourceProperties, @Qualifier(value="dw-http-client-properties") DWHttpClientProperties httpClientProperties) {
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        String seataMonitorUrl = DWApplicationConfigUtils.getProperty((String)"seataMonitorUrl");
        Objects.requireNonNull(appId, "Property 'appId' is required");
        Objects.requireNonNull(seataMonitorUrl, "Property 'seataMonitorUrl' is required");
        DataSource basicDataSource = this.creataDwBasicDataSource(dataSourceProperties);
        CloseableHttpClient httpClient = this.createHttpClient(httpClientProperties);
        DWSeataNoticeHandler noticeHandler = new DWSeataNoticeHandler(httpClient, basicDataSource, seataMonitorUrl, appId);
        DWSeataNoticeScheduler.setNoticeHandler((DWSeataNoticeHandler)noticeHandler);
        return noticeHandler;
    }

    @PreDestroy
    public void onDestroy() throws Exception {
        LOGGER.info((Object)"DWSeataNoticeScheduler cleaning up.");
        DWSeataNoticeScheduler.cleanUp();
        LOGGER.info((Object)"DWSeataNoticeScheduler clean up complete.");
    }

    @Bean(value={"dw-seata-context-filter"})
    public DWSeataContextFilter seataContextFilter() {
        return new DWSeataContextFilter();
    }

    @Bean(value={"dw-seata-context-filter-reg"})
    public FilterRegistrationBean<DWSeataContextFilter> seataContextFilterRegBean(@Qualifier(value="dw-seata-context-filter") DWSeataContextFilter seataContextFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)seataContextFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(100001);
        return registration;
    }

    @Bean(value={"dw-seata-consumer-http-aop"})
    public DefaultPointcutAdvisor dwSeataConsumerHttpRequestAop() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(* org.apache.http.client.HttpClient.execute(..)) || execution(* org.apache.hc.client5.http.classic.HttpClient.execute(..))");
        DWSeataCustomizeHttpRequestInterceptor interceptor = new DWSeataCustomizeHttpRequestInterceptor();
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }

    private CloseableHttpClient createHttpClient(DWHttpClientProperties httpClientProperties) {
        if (httpClientProperties == null) {
            httpClientProperties = new DWHttpClientProperties();
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(httpClientProperties.getMaxTotal());
        connectionManager.setDefaultMaxPerRoute(httpClientProperties.getDefaultMaxPerRoute());
        connectionManager.setValidateAfterInactivity(httpClientProperties.getValidateAfterInactivity());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(httpClientProperties.getConnectTimeout()).setConnectionRequestTimeout(httpClientProperties.getConnectionRequestTimeout()).setSocketTimeout(httpClientProperties.getSocketTimeout()).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
    }

    private DataSource creataDwBasicDataSource(DWDaoDataSourceProperties dataSourceProperties) {
        boolean dbEnabled = false;
        if (StringUtils.hasText((String)DWApplicationConfigUtils.getProperty((String)"dbEnabled"))) {
            dbEnabled = Boolean.parseBoolean(DWApplicationConfigUtils.getProperty((String)"dbEnabled"));
        }
        if (dbEnabled && StringUtils.hasText((String)dataSourceProperties.getDbUrl())) {
            String driverClassName = dataSourceProperties.getJdbcDriverClassName();
            String dbUrl = dataSourceProperties.getDbUrl();
            String dbUsername = dataSourceProperties.getDbUsername();
            String dbPassword = dataSourceProperties.getDbPassword();
            String dbPasswordEncryptionKey = dataSourceProperties.getDbPasswordEncryptionKey();
            if (dbPasswordEncryptionKey != null && !"".equals(dbPasswordEncryptionKey.trim())) {
                dbPassword = AESUtil.decode((String)dbPassword, (String)dbPasswordEncryptionKey);
            }
            int dbConnectionInitialSize = dataSourceProperties.getDbConnectionInitialSize();
            int dbConnectionMinIdle = dataSourceProperties.getDbConnectionMinIdle();
            Integer dbConnectionMaxIdle = dataSourceProperties.getDbConnectionMaxIdle();
            int dbConnectionMaxTotal = dataSourceProperties.getDbConnectionMaxTotal();
            int dbConnectionMaxWaitMillis = dataSourceProperties.getDbConnectionMaxWaitMillis();
            DWBasicDataSource basicDataSource = new DWBasicDataSource();
            basicDataSource.setDriverClassName(driverClassName);
            basicDataSource.setUrl(dbUrl);
            basicDataSource.setUsername(dbUsername);
            basicDataSource.setPassword(dbPassword);
            basicDataSource.setInitialSize(dbConnectionInitialSize);
            basicDataSource.setMinIdle(dbConnectionMinIdle);
            if (dbConnectionMaxIdle != null) {
                basicDataSource.setMaxIdle(dbConnectionMaxIdle.intValue());
            } else {
                basicDataSource.setMaxIdle(dbConnectionMaxTotal);
            }
            basicDataSource.setMaxTotal(dbConnectionMaxTotal);
            basicDataSource.setMaxWaitMillis((long)dbConnectionMaxWaitMillis);
            return basicDataSource;
        }
        return null;
    }
}

