/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.config;

import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.SentinelWebMvcConfig;
import com.digiwin.sentinel.adapter.callback.DWBlockExceptionHandler;
import com.digiwin.sentinel.adapter.interceptor.DWSentinelWebInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(name={"dwSentinelEnable"}, havingValue="true")
public class DWSentinelInterceptorConfig
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        this.addSpringMvcInterceptor(registry);
    }

    private void addSpringMvcInterceptor(InterceptorRegistry registry) {
        SentinelWebMvcConfig config = new SentinelWebMvcConfig();
        config.setBlockExceptionHandler((BlockExceptionHandler)new DWBlockExceptionHandler());
        config.setWebContextUnify(true);
        registry.addInterceptor((HandlerInterceptor)new DWSentinelWebInterceptor(config)).addPathPatterns(new String[]{"/**"});
    }
}

