/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.interceptor;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.AbstractSentinelInterceptor;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.BaseWebMvcConfig;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.SentinelWebMvcConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.gateway.filter.WebExceptionHandlerHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class DWSentinelWebInterceptor
extends AbstractSentinelInterceptor {
    private final SentinelWebMvcConfig config;

    public DWSentinelWebInterceptor() {
        this(new SentinelWebMvcConfig());
    }

    public DWSentinelWebInterceptor(SentinelWebMvcConfig config) {
        super((BaseWebMvcConfig)config);
        this.config = config == null ? new SentinelWebMvcConfig() : config;
    }

    protected String getResourceName(HttpServletRequest request) {
        String resourceName = null;
        String requestURI = request.getRequestURI();
        if (StringUtils.isNotBlank((CharSequence)requestURI) && StringUtils.endsWith((CharSequence)requestURI, (CharSequence)"/eai")) {
            String digiService = request.getHeader("digi-service");
            JSONObject digiServiceObj = JSON.parseObject((String)digiService);
            resourceName = digiServiceObj.getString("name");
        } else {
            DWTargetAPI targetAPI = (DWTargetAPI)request.getAttribute("targetAPI");
            if (targetAPI != null) {
                String moduleName = targetAPI.getHeader().getModuleName();
                DWMethod dwMethod = targetAPI.getMethod();
                DWRequestMapping dwRequestMapping = dwMethod.getMethod().getAnnotation(DWRequestMapping.class);
                if (dwRequestMapping != null) {
                    String requestMethodName = dwRequestMapping.method()[0].name();
                    String path = dwRequestMapping.path();
                    if (!path.startsWith("/") || !this.matchPathPrefix(path)) {
                        path = "/" + path;
                    }
                    resourceName = requestMethodName.toUpperCase() + ":/restful/standard/" + moduleName + path;
                } else {
                    String serviceName = targetAPI.getHeader().getServiceName();
                    String methodName = dwMethod.getMethodName();
                    resourceName = "/restful/service/" + moduleName + "/" + serviceName + "/" + methodName;
                }
            }
        }
        return resourceName;
    }

    protected String getContextName(HttpServletRequest request) {
        if (this.config.isWebContextUnify()) {
            return super.getContextName(request);
        }
        return this.getResourceName(request);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.increaseReferece(request, this.config.getRequestRefName(), -1) != 0) {
            return;
        }
        Entry entry = this.getEntryInRequest(request, this.config.getRequestAttributeName());
        if (entry == null) {
            RecordLog.warn((String)"[{}] No entry found in request, key: {}", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.config.getRequestAttributeName()});
            return;
        }
        this.traceExceptionAndExit(request, entry, ex);
        this.removeEntryInRequest(request);
        ContextUtil.exit();
    }

    protected void traceExceptionAndExit(HttpServletRequest request, Entry entry, Exception ex) {
        if (entry != null) {
            if (ex != null) {
                Tracer.traceEntry((Throwable)ex, (Entry)entry);
            } else if (this instanceof DWSentinelWebInterceptor) {
                Throwable throwable = WebExceptionHandlerHelper.getCurrentRequestException((HttpServletRequest)request);
                Tracer.traceEntry((Throwable)throwable, (Entry)entry);
            }
            entry.exit();
        }
    }

    private Integer increaseReferece(HttpServletRequest request, String rcKey, int step) {
        Object obj = request.getAttribute(rcKey);
        if (obj == null) {
            obj = 0;
        }
        Integer newRc = (Integer)obj + step;
        request.setAttribute(rcKey, (Object)newRc);
        return newRc;
    }

    private boolean matchPathPrefix(String path) {
        String patternString = "^/.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(path);
        return matcher.matches();
    }
}

