/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.cluster.config;

import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.datasource.apollo.ApolloDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.sentinel.cluster.entity.ClusterGroupEntity;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"dwSentinelEnable"}, havingValue="true")
public class DWSentinelClusterClientInitConfig {
    @Value(value="${appId}")
    private String appId;
    private static final String SEPARATOR = "@";

    @Bean
    public String initClusterConfig() throws Exception {
        this.initDynamicRuleProperty();
        this.initClientConfigProperty();
        this.initClientServerAssignProperty();
        this.initStateProperty();
        return "success";
    }

    private void initDynamicRuleProperty() {
        ApolloDataSource ruleSource = new ApolloDataSource(this.appId, "flowRules", "[]", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]));
        FlowRuleManager.register2Property((SentinelProperty)ruleSource.getProperty());
        ApolloDataSource degradeRuleSource = new ApolloDataSource(this.appId, "degradeRules", "[]", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<DegradeRule>>(){}, (Feature[])new Feature[0]));
        DegradeRuleManager.register2Property((SentinelProperty)degradeRuleSource.getProperty());
    }

    private void initClientConfigProperty() {
        ApolloDataSource clientConfigDs = new ApolloDataSource(this.appId, "clusterClientConfig", "{}", source -> (ClusterClientConfig)JSON.parseObject((String)source, (TypeReference)new TypeReference<ClusterClientConfig>(){}, (Feature[])new Feature[0]));
        ClusterClientConfigManager.registerClientConfigProperty((SentinelProperty)clientConfigDs.getProperty());
    }

    private void initClientServerAssignProperty() {
        ApolloDataSource clientAssignDs = new ApolloDataSource(this.appId, "clusterMap", "[]", source -> {
            List groupList = (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ClusterGroupEntity>>(){}, (Feature[])new Feature[0]);
            return Optional.ofNullable(groupList).flatMap(this::extractClientAssignment).orElse(null);
        });
        ClusterClientConfigManager.registerServerAssignProperty((SentinelProperty)clientAssignDs.getProperty());
    }

    private void initStateProperty() {
        ClusterStateManager.applyState((Integer)0);
    }

    private Optional<ClusterClientAssignConfig> extractClientAssignment(List<ClusterGroupEntity> groupList) {
        if (groupList.stream().anyMatch(this::machineEqual)) {
            return Optional.empty();
        }
        Iterator<ClusterGroupEntity> iterator = groupList.iterator();
        if (iterator.hasNext()) {
            ClusterGroupEntity group = iterator.next();
            String ip = group.getIp();
            Integer port = group.getPort();
            return Optional.of(new ClusterClientAssignConfig(ip, port));
        }
        return Optional.empty();
    }

    private boolean machineEqual(ClusterGroupEntity group) {
        return this.getCurrentMachineId().equals(group.getMachineId());
    }

    private String getCurrentMachineId() {
        return HostNameUtil.getIp() + SEPARATOR + TransportConfig.getRuntimePort();
    }
}

