/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.utils;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceChainInfoProvider;
import com.digiwin.app.service.DWServiceChainInfoStorage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

public class DWServiceChainUtils {
    public static String HEADER_KEY_SERVICE_CHAIN_INFO = "digi-dap-service-chain-info";
    private static Log log = LogFactory.getLog(DWServiceChainUtils.class);
    private static String identity;

    public static void setIdentity(String id) {
        identity = id;
    }

    public static String getIdentity() {
        return identity;
    }

    public static void beforeInvokeOutterAPI(DWServiceChainInfoStorage sessionInfoStorage) {
        DWServiceChainContext context = DWServiceChainContext.getContext();
        context.increaseInvocationCount();
        if (sessionInfoStorage == null) {
            log.warn((Object)"beforeInvokeOutterAPI sessionInfoStorage is null, can not pass session info to next API!");
        } else {
            String sessionInfo = context.getSessionInfo();
            sessionInfoStorage.save(HEADER_KEY_SERVICE_CHAIN_INFO, sessionInfo);
        }
    }

    public static void initContext(DWServiceChainInfoProvider sessionInfoProvider) {
        Object result;
        String sessionInfoString = null;
        if (sessionInfoProvider != null && (result = sessionInfoProvider.get(HEADER_KEY_SERVICE_CHAIN_INFO)) != null) {
            sessionInfoString = result.toString();
        }
        String selfAppId = identity;
        DWServiceChainContext context = DWServiceChainContext.getContext();
        context.initialize(selfAppId, sessionInfoString);
        ThreadContext.put((String)"sessionId", (String)context.getId());
        if (context.isRoot()) {
            log.info((Object)String.format("root invocation> %s", context.getId()));
        } else {
            log.info((Object)String.format("layer: %s, chain invocation: %s from parent> %s (appId:%s seq: %s)", context.getLayer(), context.getId(), context.getParentId(), context.getParentAppId(), context.getTraceElement().getSeq()));
        }
    }
}

