/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import com.digiwin.app.pojo.DWServiceChainCurrentElement;
import com.digiwin.app.service.utils.DWServiceChainUtils;

public class DWServiceChainContext {
    private static InheritableThreadLocal<DWServiceChainContext> _currentContext = new InheritableThreadLocal();
    private DWServiceChainCurrentElement traceElement;

    public static DWServiceChainContext getContext() {
        DWServiceChainContext context = (DWServiceChainContext)_currentContext.get();
        if (context == null) {
            context = new DWServiceChainContext();
            _currentContext.set(context);
        }
        return context;
    }

    public void initialize(String selfAppId, String sessionInfoString) {
        this.clear();
        this.traceElement = new DWServiceChainCurrentElement(selfAppId, sessionInfoString);
    }

    public DWServiceChainCurrentElement getTraceElement() {
        if (this.traceElement == null) {
            this.traceElement = new DWServiceChainCurrentElement(DWServiceChainUtils.getIdentity(), null);
        }
        return this.traceElement;
    }

    public String getParentId() {
        return this.getTraceElement().getParentId();
    }

    public String getParentAppId() {
        return this.getTraceElement().getParentAppId();
    }

    public String getId() {
        return this.getTraceElement().getId();
    }

    public String getAppId() {
        return this.getTraceElement().getAppId();
    }

    public int getLayer() {
        return this.getTraceElement().getLayer();
    }

    public int getSeq() {
        return this.getTraceElement().getSeq();
    }

    public boolean isRoot() {
        return this.getTraceElement().isRoot();
    }

    public String getSessionInfo() {
        return this.getTraceElement().toString();
    }

    public static String getTraceInfo(boolean includeSelf) {
        return DWServiceChainContext.getContext().getTraceElement().getTraceInfo(includeSelf);
    }

    public int increaseInvocationCount() {
        return this.getTraceElement().increaseInvocationCount();
    }

    public void clear() {
        this.traceElement = null;
    }
}

