/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor;

import com.digiwin.app.service.DWServiceChainInfoStorage;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWCallOuterAPIBaseInterceptor<T>
implements MethodInterceptor {
    private static Log log = LogFactory.getLog(DWCallOuterAPIBaseInterceptor.class);
    private Class<T> targetArgumentType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object o = invocation.getThis();
        Object[] arguments = invocation.getArguments();
        T targetArgument = this.getTargetArgument(arguments);
        if (targetArgument == null) {
            log.error((Object)String.format("service chain target argument(type=%s) is null, can not deliver session info to next API!", this.targetArgumentType.getName()));
        } else {
            this.beforeInvoke(targetArgument);
        }
        try {
            Object result = method.invoke(o, arguments);
            this.afterInvoke(result);
            return result;
        }
        catch (Throwable e) {
            this.onException(e);
            throw e;
        }
    }

    protected T getTargetArgument(Object[] arguments) {
        Object targetArgument = null;
        for (Object argument : arguments) {
            if (!this.targetArgumentType.isAssignableFrom(argument.getClass())) continue;
            targetArgument = argument;
            break;
        }
        return (T)targetArgument;
    }

    protected void beforeInvoke(T targetArgument) {
        DWServiceChainInfoStorage storage = this.getStorage(targetArgument);
        DWServiceChainUtils.beforeInvokeOutterAPI(storage);
    }

    protected abstract DWServiceChainInfoStorage getStorage(T var1);

    protected void onException(Throwable e) {
    }

    protected void afterInvoke(Object result) {
    }
}

