/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.processor;

import com.digiwin.app.service.processor.DWInvokerBeanProcessor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class DWInvokerBeanContainerBeanProcessor
implements BeanPostProcessor {
    private static Log log = LogFactory.getLog(DWInvokerBeanContainerBeanProcessor.class);
    private List<DWInvokerBeanProcessor> targetProcessors = new ArrayList<DWInvokerBeanProcessor>();

    public void registerProcessor(DWInvokerBeanProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor is null!");
        }
        this.targetProcessors.add(processor);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object targetProcessor = null;
        try {
            targetProcessor = this.targetProcessors.stream().filter(p -> p.accept(bean)).findFirst().orElse(null);
            if (targetProcessor != null) {
                return targetProcessor.process(bean, beanName);
            }
        }
        catch (Exception e) {
            String type = targetProcessor == null ? "" : targetProcessor.getClass().getName();
            log.error((Object)String.format("Service Chain DWInvokerBeanDefaultProcessor failed! type=%s, beanName=%s", type, beanName), (Throwable)e);
        }
        return bean;
    }

    public static <T> List<T> getFieldListValue(Object bean, String fieldName, Class<? extends T> processorType) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        boolean isProcessorExist = false;
        Field processorsField = ReflectionUtils.findField(bean.getClass(), (String)fieldName);
        processorsField.setAccessible(true);
        Object sourceValue = processorsField.get(bean);
        ArrayList<Object> value = sourceValue != null && sourceValue.getClass().isArray() ? new ArrayList<Object>(Arrays.asList((Object[])sourceValue)) : (ArrayList<Object>)sourceValue;
        processorsField.setAccessible(false);
        if (value == null) {
            value = new ArrayList();
        } else {
            isProcessorExist = value.stream().anyMatch(processorType::isInstance);
        }
        if (isProcessorExist) {
            return null;
        }
        value.add(processorType.newInstance());
        return value;
    }

    public static <T> T[] getFieldArrayValue(Object bean, String fieldName, Class<T> baseClass, Class<? extends T> processorType) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        List<Object> value = DWInvokerBeanContainerBeanProcessor.getFieldListValue(bean, fieldName, processorType);
        return value == null ? null : value.toArray((Object[])Array.newInstance(baseClass, value.size()));
    }
}

