/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.utils;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceChainInfoProvider;
import com.digiwin.app.service.DWServiceChainInfoStorage;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

public class DWServiceChainUtils {
    public static String HEADER_KEY_SERVICE_CHAIN_INFO = "digi-dap-service-chain-info";
    public static String HEADER_KEY_SERVICE_CHAIN_TARGET_ID = "digi-dap-service-chain-target-id";
    public static String HEADER_KEY_EAI_CALLBACK_SRV_CHAIN_INFO = "digi-callback-dap-service-chain-info";
    private static Log log = LogFactory.getLog(DWServiceChainUtils.class);
    private static String identity;
    private static Consumer<DWServiceChainContext> receivedPrinter;

    public static void setIdentity(String id) {
        identity = id;
    }

    public static String getIdentity() {
        return identity;
    }

    public static void setPrinterType(String type) {
        if ("full".equalsIgnoreCase(type)) {
            receivedPrinter = DWServiceChainUtils::fullInfoPrinter;
        }
    }

    public static boolean isServiceChainEnabled() {
        return identity != null;
    }

    public static void beforeInvokeOutterAPI(DWServiceChainInfoStorage sessionInfoStorage) {
        DWServiceChainUtils.beforeInvokeOutterAPI(false, sessionInfoStorage);
    }

    public static void beforeInvokeEAICallbackAPI(Map<String, Object> requestHeaderMap) {
        DWServiceChainUtils.cleanSessionInfo(requestHeaderMap);
        DWServiceChainUtils.beforeInvokeOutterAPI(true, requestHeaderMap::put);
    }

    private static void cleanSessionInfo(Map<String, Object> requestHeaderMap) {
        try {
            requestHeaderMap.remove(HEADER_KEY_SERVICE_CHAIN_INFO);
        }
        catch (Throwable e) {
            log.warn((Object)"Can not clean session info!");
        }
    }

    private static void beforeInvokeOutterAPI(boolean isCallbackRequest, DWServiceChainInfoStorage sessionInfoStorage) {
        DWServiceChainContext context = DWServiceChainContext.getContext();
        context.increaseInvocationCount();
        if (sessionInfoStorage == null) {
            log.warn((Object)"beforeInvokeOutterAPI sessionInfoStorage is null, can not pass session info to next API!");
        } else {
            String sessionInfo = context.getSessionInfo();
            sessionInfoStorage.save(isCallbackRequest ? HEADER_KEY_EAI_CALLBACK_SRV_CHAIN_INFO : HEADER_KEY_SERVICE_CHAIN_INFO, sessionInfo);
        }
    }

    public static void main(String[] args) throws Exception {
        String sessionInfo = "1,1:crusc^a5f0a809-008b-436b-97f8-37d58bbe5ea3,crusc^fcf04ef1-b111-45b1-a77c-3bf9b1f38405";
        DWServiceChainUtils.recoveryFromChildInfo(sessionInfo);
    }

    public static void recoveryFromChildInfo(String childSessionInfoString) {
        String selfAppId = identity;
        DWServiceChainContext context = DWServiceChainContext.getContext();
        context.recoveryFromChildInfo(selfAppId, childSessionInfoString);
        ThreadContext.put((String)"sessionId", (String)context.getId());
    }

    public static void initContext(DWServiceChainInfoProvider sessionInfoProvider) {
        String sessionInfoString = null;
        if (sessionInfoProvider != null) {
            Object result = sessionInfoProvider.get(HEADER_KEY_SERVICE_CHAIN_INFO);
            if (result == null) {
                result = sessionInfoProvider.get(HEADER_KEY_EAI_CALLBACK_SRV_CHAIN_INFO);
            }
            if (result != null) {
                sessionInfoString = result.toString();
            }
        }
        String selfAppId = identity;
        DWServiceChainContext context = DWServiceChainContext.getContext();
        context.initialize(selfAppId, sessionInfoString);
        ThreadContext.put((String)"sessionId", (String)context.getId());
        if (context.isRoot()) {
            log.info((Object)String.format("root invocation> %s", context.getId()));
        } else {
            receivedPrinter.accept(context);
        }
    }

    private static void standardPriner(DWServiceChainContext context) {
        log.info((Object)String.format("trace info> me: %s, layer=%s from parent> %s (appId=%s seq=%s)", context.getId(), context.getLayer(), context.getParentId(), context.getParentAppId(), context.getTraceElement().getSeq()));
    }

    private static void fullInfoPrinter(DWServiceChainContext context) {
        log.info((Object)context.getTraceElement().getTraceInfo(true));
    }

    static {
        receivedPrinter = DWServiceChainUtils::standardPriner;
    }
}

