/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.DWSecurityRequestWrapper;
import com.digiwin.gateway.service.permission.config.DWServicePermissionConfig;
import com.digiwin.gateway.service.permission.pojo.DWSecurityToken;
import com.digiwin.gateway.service.permission.util.DWFilterUtil;
import com.digiwin.gateway.service.permission.util.DWSecurityTokenUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;

public class DWSecurityContextInitFilter
implements Filter {
    private static final Log log = LogFactory.getLog(DWSecurityContextInitFilter.class);
    public static final String KEY_SECURITY_TOKEN = "security-token";
    public static final String KEY_USER_TOKEN = "token";
    public static final String KEY_APP_TOKEN = "digi-middleware-auth-app";
    @Autowired
    @Qualifier(value="dw-service-permission-config")
    DWServicePermissionConfig servicePermissionConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        securityContext.remove();
        String securityToken = req.getHeader(KEY_SECURITY_TOKEN);
        boolean openTrustChain = this.servicePermissionConfig.isOpenTrustChain();
        if (null != securityToken && !securityToken.trim().isEmpty() && openTrustChain) {
            try {
                DWSecurityToken securityTokenBean = DWSecurityTokenUtil.parseSecurityToken(securityToken);
                Instant expirationTime = Instant.ofEpochMilli(securityTokenBean.getExpirationTime());
                if (!expirationTime.isBefore(Instant.now())) {
                    DWSecurityContext context = securityTokenBean.getContext();
                    DWSecurityContext.setSecurityContext(context);
                    String userToken = context.getUserToken();
                    String appToken = context.getAppToken();
                    Map<String, Object> profile = context.getProfile();
                    DWSecurityRequestWrapper httpReq = new DWSecurityRequestWrapper(req);
                    httpReq.addHeader(KEY_USER_TOKEN, userToken);
                    httpReq.addHeader(KEY_APP_TOKEN, appToken);
                    httpReq.addHeader(KEY_SECURITY_TOKEN, securityToken);
                    DWServiceContext.getContext().setToken(userToken);
                    DWServiceContext.getContext().setProfile(profile);
                }
            }
            catch (Exception e) {
                String errorStr = "\u9084\u539f\u5b89\u5168\u4e0a\u4e0b\u6587\u6642\u51fa\u932f";
                log.error((Object)errorStr, (Throwable)e);
                HashMap<String, Object> errorMsg = new HashMap<String, Object>();
                errorMsg.put(errorStr, e.getMessage());
                DWFilterUtil.generateErrorResponse(HttpStatus.BAD_REQUEST, resp, errorMsg);
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

