/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission.util;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.pojo.DWSecurityToken;
import com.digiwin.gateway.service.permission.util.AESUtil;
import com.google.gson.Gson;
import java.time.Instant;

public final class DWSecurityTokenUtil {
    static final long EFFECTIVE_TIME = 600000L;

    DWSecurityTokenUtil() {
    }

    public static String generateSecurityToken(DWSecurityContext context) throws Exception {
        DWSecurityToken securityToken = new DWSecurityToken();
        securityToken.setContext(context);
        securityToken.setExpirationTime(Instant.now().toEpochMilli() + 600000L);
        return AESUtil.encrypt(new Gson().toJson((Object)securityToken));
    }

    public static DWSecurityToken parseSecurityToken(String securityToken) throws Exception {
        try {
            String decryptToken = AESUtil.decrypt(securityToken);
            return (DWSecurityToken)new Gson().fromJson(decryptToken, DWSecurityToken.class);
        }
        catch (Exception e) {
            throw new DWRuntimeException("\u65e0\u6548\u7684security-token\uff01\uff01");
        }
    }
}

